//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.16; Page 344
  //Title: calculating the difference between heating value under constant pressure and heating value under constant volume
model Ex9_16
//parameter section
parameter Real ba(unit="lb")=1 "amount of fuel oil as basis";
parameter Real T(unit="C")=25 "temperature detected by calorimeter";
parameter Real dn1(unit="lb-moles")=0 "change in number og moles of gas in reaction: C(fuel oil)+O2(g)  -->CO2(g)";
parameter Real dn2(unit="lb-moles")=-0.5 "change in number og moles of gas in reaction: H2(fuel oil)+1/2 O2(g)-->H2O2(l)";
parameter Real pC(unit=" ")=87 "percent of carbon in fuel oil";
parameter Real pH(unit=" ")=13 "percent of Hydrogen in fuel oil";
parameter Real aF(unit="lb")=1 "amount of fuel oil";
parameter Real R(unit="cal/mol-K")=1.987 "universal gas constant";
parameter Real c1(unit=" ")=1.8 "1K=1.8R; conversion factor from K to rankine";
parameter Real MH(unit="g")=2.016 "Molar mass of H2";
//variable section
Real d(unit="Btu/lb") "difference between heating value under constant pressure and heating value under constant volume";
Real aH(unit="lb-mole") "amount of hydrogen in lb-moles";
//equation section
equation
aH=ba*pH/100/MH;
d=-dn2*aH*R*c1*(T+273.15);
end Ex9_16;
