//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.17; Page 348
  //Title: Calculating heat evolved in reaction chamber in kcal/kg-mole
model Ex9_17
//parameter section
parameter Real ba(unit="kg-mole")=1 "amount of CO taken as basis";
/*reaction: CO+0.5O2-->CO2*/
parameter Real Tr(unit="C")=25 "Reference temperature";
parameter Real TC(unit="C")=200 "Temperature of CO";
parameter Real TA(unit="C")=500 "Temperature of air";
parameter Real Tf(unit="C")=1000 "Temperature of product gases";
parameter Real HC(unit="kcal")=-67636 "Heat of combustion of CO";
parameter Real aOrb(unit="kg-mole")=0.5 "amount of O2 required per kg-mole CO";
parameter Real eOr(unit=" ")=90 "percentage excess oxygen required";
parameter Real aOA(unit=" ")=0.21 "fraction of O2 in air";
parameter Real HcCO(unit="kcal/(kg-mole*C)")=7.017 "mean molal Heat capacity of CO";
parameter Real HcA(unit="kcal/(kg-mole*C)")=7.225 "mean molal Heat capacity of air";
parameter Real HcCO2(unit="kcal/(kg-mole*C)")=11.92 "mean molal Heat capacity of CO2";
parameter Real HcO(unit="kcal/(kg-mole*C)")=7.941 "mean molal Heat capacity of O2";
parameter Real HcN(unit="kcal/(kg-mole*C)")=7.507 "mean molal Heat capacity of N2";

//variable section
Real aOs(unit="kg-mole") "amount of O2 supplied";
Real aAs(unit="kg-mole") "amount of air supplied";
Real aNs(unit="kg-mole") "amount of N2 supplied";
Real ECOs(unit="kcal") "enthalpy of CO supplied";
Real EAs(unit="kcal") "enthalpy of air supplied";
Real ECO2s(unit="kcal") "enthalpy of CO2 product";
Real EOs(unit="kcal") "enthalpy of O2 product";
Real ENs(unit="kcal") "enthalpy of N2 product";
Real Hr(unit="kcal") "enthalpy of reactants";
Real Hp(unit="kcal") "enthalpy of products";
Real He(unit="kcal") "amount of Heat evolved";
//equation section
equation
aOs=aOrb*(1+eOr/100);
aAs=aOs/aOA;
aNs=aAs-aOs;
ECOs=ba*HcCO*(TC-Tr);
EAs=aAs*HcA*(TA-Tr);
ECO2s=ba*HcCO2*(Tf-Tr) "Amount of CO2 produced is same as amount of CO used";
EOs=(aOs-aOrb)*HcO*(Tf-Tr);
ENs=aNs*HcN*(Tf-Tr);
Hr=(ECOs+EAs);
Hp=(EOs+ENs+ECO2s);
He=Hp+HC-Hr;
end Ex9_17;
