//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.22; Page 359
  //Title: Calculating the amount of Uranium 235 required per day to generate 100 MW heat and comparing this with amount of carbon burnt by combustion
model Ex9_22
//parameter section
parameter Real aHg(unit="MW")=100 "amount of heat to be generated";
parameter Real mU(unit="g")=235.11240 "Molar mass of Uranium";
parameter Real mN(unit="g")=1.00898 "Molar mass of neutron";
parameter Real mMo(unit="g")=99.94686 "Molar mass of Molybdenum";
parameter Real mXe(unit="g")=133.96517 "Molar mass of Xenon";
parameter Real mB(unit="g")=0.00055 "Molar mass of beta particle";
parameter Real c(unit="cm/s")=2.998*10^10 "speed of light";
parameter Real c1(unit=" ")=4.184*10^7 "1cal=4.184*10^7erg";
parameter Real c2(unit=" ")=20.65*10^11 "100MW=20.65*10^11cal per day";
parameter Real Hc(unit="cal/g-mole")=-94.0518*10^3 "heat of combustion of carbon at 25 degree C";
parameter Real MC(unit="g")=12.01 "Molar mass of carbon";
/*Reaction: U(235)+n-->Mo(100)+Xe(134)+2n+4beta+E*/
//variable section
Real md(unit="g") "mass defect";
Real E(unit="erg") "energy released due to mass defect";
Real Ec(unit="cal") "energy released due to mass defect in cal";
Real mUn(unit="g") "mass of uranium required per day";
Real aCn(unit="g") "amount of carbon required";
//equation section
equation
md= mU+mN-mMo-mXe-2*mN-4*mB;
E=md*c^2;
Ec=E/c1;
mUn=c2/Ec*mU;
aCn=abs(c2/Hc*MC);
end Ex9_22;
