//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.9; Page 323
  //Title: Calculating integral heat of solution of glycerine and water
model Ex9_9
//parameter section
parameter Real pG(unit=" ")=40 "percent of glycerine in solution";
parameter Real Hs(unit="cal/g")=-4.5 "Heat of solution per gram solution";
parameter Real ba(unit="g")=1 "amount of solution taken as basis";
//variable section
Real HsG(unit="cal/g") "heat of solution of glycerine in water";
Real HsW(unit="cal/g") "heat of solution of water in glycerine";
//equation section
equation
HsG=Hs/(ba*pG/100);
HsW=Hs/(ba*(1-pG/100));
end Ex9_9;
