//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-10:Adsorption
  //Example 10.4; Page 391
  //Title: Calculating total heat to be removed for drying air
model Ex10_4
//parameter section
parameter Real ba(unit="lb")=100 "amount of dry air as basis";
parameter Real iH(unit=" ")=0.01 "Initial humidity of air";
parameter Real fH(unit=" ")=0.001 "final humidity of air";
parameter Real ag(unit="lb")=10 "amount of gel";
parameter Real Eai(unit="Btu/lb")=18 "Enthalpy of air initially per lb dry air at 70 degree F";
parameter Real Eaf(unit="Btu/lb")=27.7 "Enthalpy of air finally per lb dry air at 70 degree F";
parameter Real Esi(unit="Btu/lb")=-14 "Enthalpy of silica gel initially per lb dry silica gel at 70 degree F";
parameter Real Esf(unit="Btu/lb")=6 "Enthalpy of silica gel finally per lb dry silica gel at 80 degree F";
//variable section
Real acg(unit=" ") "average composition of gel after absorption";
Real Ha(unit="Btu") "Heat removed from air";
Real Hs(unit="Btu") "Heat removed from silica gel";
Real Ht(unit="Btu") "total heat removed";
//equation section
equation
acg=ba*(iH-fH)/ag;
Ha=ba*(Eaf-Eai);
Hs=ag*(Esf-Esi);
Ht=Ha+Hs;
end Ex10_4;
