//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-10:Adsorption
  //Example 10.5; Page 392
  //Title: Calculating heat evolved per pound of water adsorbed
model Ex10_5
//parameter section
parameter Real as(unit="lb")=250 "amount of silica gel";
parameter Real aw(unit="lb")=28 "amount of water adsorbed";
parameter Real c1(unit=" ")=453.6 "1lb=453.6g; conversion factor from lb to g";
parameter Real c2(unit=" ")=252.16 "1Btu=252.16cal";
parameter Real MW(unit="g")=18 "Molar mass of water";
//variable section
Real cw(unit=" ") "Concentration of water in silica gel";
Real cwv(unit="cc/g") "Concentration in cc/g of water vapor";
Real He(unit="Btu/lb") "Heat evolved in Btu per lb";
//equation section
equation
cw=aw/as;
cwv=cw*22400;
/*This value from graph corresponds to 12500 cal/g-mole heat evolved*/
He=12500*c1/c2/MW;
end Ex10_5;
