//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-2:Stoichometric and composition Relationships
//Example 2.1; Page 30
//Title: Finding volume occupied by 25lb chlorine at standard conditions
model Ex2_1
//parameter section
parameter Real m(unit="lb")=25 "Given mass of chlorine";
parameter Real M(unit="g")=70.92 "Molar mass of chlorine";
parameter Real V(unit="(cu ft)/lb-mole")=359 "Specific volume of any gas at standard conditions";
//variable section
Real v(unit="cu ft") "volume occupied by 25lb chlorine at standard conditions";
Real n(unit="lb-moles") "number of moles of 25lb gaseous chlorine";
//equation section
equation
n=m/M "Finding number of moles";
v=n*V "Finding volume occupied by 25lb Cl2";
end Ex2_1;
