//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-2:Stoichometric and composition Relationships
  //Example 2.7; Page 39
  //Title: Finding composition in mole per cent
package Ex2_7
        
  model Ex2_7_a
    //parameter section
    parameter Real mN(unit = "g") = 230 "amount of NaCl in aqueous solution";
    parameter Real vS(unit = "L") = 1 "Volume of solution in Litres";
    parameter Real T(unit = "C") = 20 "Temperature of solution";
    parameter Real D(unit = "g/(cc)") = 1.148 "Density of solution at 20 degree C";
    parameter Real MN(unit = "g") = 58.5 "Molar mass of NaCl";
    parameter Real MW(unit = "g") = 18.02 "Molar mass of H2O";
    parameter Real c1(unit = "L/(cc)") = 1000 "COnversion factor from L to cu cm";
    //variable section
    Real mS(unit = "g") "Mass of solution";
    Real mW(unit = "g") "Mass of water in solution";
    Real yN(unit = " ") "Mass per cent of NaCl in solution";
    Real yW(unit = " ") "Mass per cent of H2O in solution";
    //equation section
  equation
    mS = D * (vS * c1);
    mW = mS - mN;
    yN = mN / mS;
    yW = mW / mS;
  end Ex2_7_a;

  /*Uses the value of mass from Ex2.7a*/
  model Ex2_7_b
    extends Ex2_7_a;
    //parameter section
    parameter Real DW(unit = "g/(cc)") = 0.998 "Density of water at 20 degree C";
    //variable section
    Real vW(unit = "cc") "Volume of water in solution";
    Real vN(unit = "cc") "Volume of NaCl in solution";
    Real vpW(unit = " ") "Volumetric percent of water in solution";
    //equation section
  equation
    vW = mW / DW;
    vpW = vW / 100;
    vN = vS * c1 - vW;
  end Ex2_7_b;


  /*Uses the value of parameters from 2.7c*/
  model Ex2_7_c
    extends Ex2_7_b;
    //variable section
    Real nN(unit = "moles") "number of moles of NaCl";
    Real nW(unit = "moles") "number of moles of H2O";
    Real xN(unit = " ") "mole percent of NaCl";
    Real xW(unit = " ") "mole percent of H2O";
    //equation section
  equation
    nN = mN / MN;
    nW = mW / MW;
    xN = nN / (nN + nW) * 100;
    xW = nW / (nN + nW) * 100;
  end Ex2_7_c;


  /* Uses the values of number of moles from Ex2.7c*/
  model Ex2_7_d
  extends Ex2_7_c;
  //parameter section
  parameter Real N0=6.022*10^23 "Avogadro's number";
  //variable section
  Real AN(unit=" ") "Number of atoms of Na";
  Real AC(unit=" ") "Number of atoms of Cl";
  Real AH(unit=" ") "Number of atoms of H";
  Real AO(unit=" ") "Number of atoms of O";
  Real aN(unit=" ") "atom % of Na";
  Real aC(unit=" ") "atom % of Cl";
  Real aH(unit=" ") "atom % of H";
  Real aO(unit=" ") "atom % of O";
  //equation section
  equation
  AN=nN*N0;
  AC=nN*N0;
  AH=2*nW*N0;
  AO=nW*N0;
  aN=AN/(AN+AC+AH+AO)*100;
  aC=AC/(AN+AC+AH+AO)*100;
  aH=AH/(AN+AC+AH+AO)*100;
  aO=AO/(AN+AC+AH+AO)*100;
  end Ex2_7_d;



end Ex2_7;
