//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.5; Page 55
  //Title: Finding percentage dissociation of N2O4 to NO2
model Ex3_5
//parameter  section
parameter Real T(unit="C")=100 "Temperature at which reaction takes place";
parameter Real P(unit="mmHg")=720 "Pressure at which reaction takes place";
parameter Real m(unit="g")=17.2 "mass of N2O4 gas";
parameter Real v(unit="cc")=11450 "volume occupies by N2O4 gas at above conditions";
parameter Real R(unit="J/(moles*K)")=8.314 "Universal gas constant";
parameter Real c1(unit=" ")=7.60*10^(-3) "1Pa=7.60*10^(-3)mmHg";
parameter Real c2(unit=" ")=10^(-6) "1m^3=10^6cc";
parameter Real M(unit="g")=92 "Molar mass of N2O4";
//variable section
Real x(unit="moles") "moles of N2O4 dissociated";
Real n(unit="moles") "moles of N2O4 before reaction starts";
Real N(unit="moles") "moles found using ideal gas equation";
Real d(unit=" ") "Percentage dissociation";
//equation section
equation
n=m/M;
(P/c1)*(v*c2)=N*R*(T+273.15);
N=(n-x)+2*x "n-x moles of N2O4 remains and 2*x moles of NO2 forms after dissociation as N2O4-->2NO2";
d=(x/n)*100;
end Ex3_5;
