//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-4:Vapor Pressures
//Example 4.9; Page 102
//Title: Calculating total pressure and composition of Benzene, Toluene and orthoxylene in liquid-gas mixture
model Ex4_9
//parameter section
parameter Real ba(unit="g")=100 "basis of mixture";
parameter Real wpb(unit=" ")=35 "weight percent of benzene";
parameter Real wpt(unit=" ")=40 "weight percent of toluene";
parameter Real wpo(unit=" ")=25 "weight percent of orthoxylene";
parameter Real MB(unit="g")=78 "Molar mass of benzene";
parameter Real MT(unit="g")=92 "Molar mass of toluene";
parameter Real MO(unit="g")=106 "Molar mass of orthoxylene";
parameter Real PB(unit="mmHg")=1340 "vapor pressure of pure benzene at 100 degree C";
parameter Real PT(unit="mmHg")=560 "vapor pressure of pure toluene at 100 degree C";
parameter Real PO(unit="mmHg")=210 "vapor pressure of pure orthoxylene at 100 degree C";
//variable section
Real wb(unit="g") "mass of benzene in mixture";
Real wt(unit="g") "mass of toluene in mixture";
Real wo(unit="g") "mass of orthoxylene in mixture";
Real mb(unit="moles") "moles of benzene in mixture";
Real mt(unit="moles") "moles of toluene in mixture";
Real mo(unit="moles") "moles of orthoxylene in mixture";
Real m(unit="moles") "Total moles in  mixture";
Real Pb(unit="mmHg") "partial pressure of benzene";
Real Pt(unit="mmHg") "partial pressure of toluene";
Real Po(unit="mmHg") "partial pressure of orthoxylene";
Real P(unit="mmHg") "Total pressure";
Real mplb(unit=" ") "mole percent of benzene in liquid mixture";
Real mplt(unit=" ") "mole percent of toluene in liquid mixture";
Real mplo(unit=" ") "mole percent of orthoxylene in liquid mixture";
Real mpvb(unit=" ") "mole percent of benzene in vapor mixture";
Real mpvt(unit=" ") "mole percent of toluene in vapor mixture";
Real mpvo(unit=" ") "mole percent of orthoxylene in vapor mixture";
//equation section
equation
wb=ba*(wpb/100);
wt=ba*(wpt/100);
wo=ba*(wpo/100);
mb=wb/MB;
mt=wt/MT;
mo=wo/MO;
m=mb+mt+mo;
mplb=mb/m;
mplt=mt/m;
mplo=mo/m;
Pb=PB*mb/m;
Pt=PT*mt/m;
Po=PO*mo/m;
P=Pb+Pt+Po;
mpvb=Pb/P;
mpvt=Pt/P;
mpvo=Po/P;
end Ex4_9;
