package Ex5_5
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-5:Humidity and Saturation
  //Example 5.5; Page 116
  //Title: Calculating vapor concentration of gases entering and leaving evaporator in moles of vapor per mole of vapor-free gas

  model Ex5_5_a
    //parameter section
    parameter Real T1(unit = "C") = 30 "Initial temp of mixture";
    parameter Real T2(unit = "C") = 10 "Dew point of acetone contained in mixture";
    parameter Real T3(unit = "C") = 25 "Final temp of mixture";
    parameter Real T4(unit = "C") = 20 "Dew point of acetone contained in mixture";
    parameter Real P(unit = "mmHg") = 750 "barometric pressure- contant throughout";
    parameter Real P1a(unit = "mmHg") = 116 "Vapor pressure of acetone at 10 degree C";
    parameter Real P2a(unit = "mmHg") = 185 "Vapor pressure of acetone at 20 degree C";
    //variable section
    Real p1a(unit = "mmHg") "partial pressure of acetone initially";
    Real p2a(unit = "mmHg") "partial pressure of acetone finally";
    Real p1n(unit = "mmHg") "Partial pressure of N2 entering";
    Real p2n(unit = "mmHg") "Partial pressure of N2 leaving";
    Real an1(unit = " ") "moles of acetone per mole of N2 initial";
    Real an2(unit = " ") "moles of acetone per mole of N2 final";
    //equation section
  equation
    p1a = P1a;
    p2a = P2a;
    p1n = P - p1a;
    p2n = P - p2a;
    an1 = p1a / p1n;
    an2 = p2a / p2n;
  end Ex5_5_a;

  //title: Calculating moles of acetone evaporated per mole vapor free gas
  model Ex5_5_b
  /*Uses the ratio found in Ex5.5a*/
  extends Ex5_5_a;
  //parameter section
  parameter Real ba(unit="lb-moles")=1 "basis of calculation";
  //variable section
  Real maen(unit="lb-moles") "moles of acetone entering";
  Real maex(unit="lb-moles") "moles of acetone exiting";
  Real maev(unit="lb-moles") "moles of acetone evaporated";
  //equation section
  equation 
  maen=ba*an1;
  maex=ba*an2;
  maev=maex-maen;
  end Ex5_5_b;


  //Title: Calculating weight of acetone evaporated
  model Ex5_5_c
  /*Uses value of parameters and answers of Ex5.5b*/
  extends Ex5_5_b;
  //parameter section
  parameter Real V1(unit="cuft")=1000 "Volume of gas entering evaporator";
  parameter Real P0(unit="mmHg")=760 "Pressure at standard conditions";
  parameter Real T0(unit="K")=273.15 "Temperature at standard conditions";
  parameter Real V0(unit="cuft")=359 "Volume at standard conditions per lb-mole gas";
  parameter Real MA(unit="g")=58 "Molar mass of acetone";
  //variable section
  Real nen(unit="lb-moles") "Total moles in mixture entering";
  Real naen(unit="lb-moles") "Moles of acetone entering per 1000cuft of mixture entering";
  Real nnen(unit="lb-moles") "Moles of N2 entering per 1000cuft of mixture entering";
  Real waen(unit="lb") "mass of acetone in entering mixture";
  Real naex(unit="lb-moles") "moles of acetone in exiting mixture";
  Real nex(unit="lb-moles") "total moles exiting";
  Real waex(unit="lb") "mass of acetone in exiting mixture";
  Real waev(unit="lb") "mass of acetone evaporated";
  //equation section
  equation
  nen=(P/P0)*(V1/V0)*(T0/(T1+273.15));
  naen+nnen=nen;
  naen=an1*nnen;
  waen=MA*naen;
  naex=an2*nnen;
  waex=MA*naex;
  waev=waex-waen;
  nex=nnen+naex;
  end Ex5_5_c;



  //Title: Finding volume of gases exiting per 1000cuft gases entering
  model Ex5_5_d
  /*uses the parameters and value of no. of moles exiting from Ex5.5c*/
  extends Ex5_5_c;
  //variable section
  Real Vex(unit="cu ft") "Total volume of gases exiting";
  //equation section
  equation
  Vex=nex*V0*((T3+273.15)/T0)*(P0/P);
  end Ex5_5_d;










end Ex5_5;
