//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-5:Humidity and Saturation
  //Example 5.7; Page 119
  //Title: Finding the final pressure
model Ex5_7
//parameter section
parameter Real ba(unit="lb-moles")=1 "basis of calculation";
parameter Real P1(unit="mmHg")=750 "initial pressure of mixture";
parameter Real ac(unit=" ")=90 "percent of acetone to condense";
parameter Real vpa1(unit="mmHg")=229.2 "vapor pressure of acetone at 25 degree C";
parameter Real vpa2(unit="mmHg")=89.1 "vapor pressure of acetone at 5 degree C";
//variable sectiion
Real ppa1(unit="mmHg") "partial pressure of acetone initially";
Real ppa2(unit="mmHg") "partial pressure of acetone finally";
Real na1(unit="lb-moles") "number of moles of acetone initially";
Real nd1(unit="lb-moles") "number of moles of dry gas";
Real na2(unit="lb-moles") "number of moles of acetone finally";
Real P2(unit="mmHg") "Final pressure of mixture";
//equation section
equation
ppa1=vpa1;
ppa2=vpa2;
na1=ba*(ppa1/P1);
nd1=ba-na1;
na2=na1*(1-ac/100);
P2=((na2+nd1)/na2)*vpa2;
end Ex5_7;
