//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.6; Page 148
  //Title: Calculating amount of ice formed
  model Ex6_6
  //parameter section
  parameter Real ba(unit="g")=1000 "amount of H2O initially as basis";
  parameter Real aNi(unit="g")=100 "amount of NaNO3 in solution initially";
  parameter Real sN2(unit="g-moles")=6.2 "amount of NaNO3 soluble in water at -15 degree C in 1000g H2O";
  parameter Real MN(unit="g")=85 "molar mass of NaNO3";
  parameter Real ms2(unit="g")=1000 "mass of initial solution to be taken";
  //variable section
  Real aHr(unit="g") "amount of H2O remaining in solution";
  Real aif(unit="g") "amount of ice formed";
  Real aif2(unit="g") "amount of ice formed in 1000g solution";
  Real ms(unit="g") "mass of solution initially according to basis";
  //equation section
  equation
  aHr=1000*(aNi/(sN2*MN))*(ba/1000);
  aif=ba-aHr;
  ms=ba+aNi;
  aif2=aif*ms2/ms;
end Ex6_6;
