 //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-7:Material Balances
  //Example 7.5; Page 209
  //Title: Calculating weight of sodium carbonate recovered
model Ex7_5
//parameter section
parameter Real ba(unit="lb")=1000 "amount of inert solid as basis";
parameter Real wd(unit="lb")=3 "amount of solution with sludge discharged per unit mass sludge";
parameter Real sf(unit="lb")=1 "amount of solute with sludge in feed per unit mass sludge";
parameter Real wf(unit="lb")=3 "amount of solution with sludge in feed per unit mass sludge";
parameter Real Wf(unit="lb")=10 "amount of solution discharged per unit mass sludge";
parameter Real N(unit=" ")=3 "number of tanks";
//variable section
Real c(unit=" ") "a constant";
Real U(unit=" ") "fraction of solute unextracted";
Real sum(unit=" ") "dummy variable"; 
Real au(unit="lb") "amount of solute unextracted";
Real ar(unit="lb") "amount of solute recovered";
//algorithm section
algorithm
for i in 0:N loop
sum:=sum+c^i;
end for;
//equation section
equation
c=wf/Wf;
U=c^N/sum;
au=U*ba;
ar=ba-au;
end Ex7_5;
