//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-8: Thermophysics
  //Example 8.4; Page 281
  //Title: Latent heat of vaporization of ethyl alcohol
model Ex8_4
//parameter section
parameter Real Hv(unit="cal/g")=204 "Latent heat of vaporization of ethyl alcohol at 78 degree C";
parameter Real Tn(unit="C")=78 "Normal boiling temperature of ethyl alcohol";
parameter Real Tc(unit="C")=243 "critical temperature of ethyl alcohol";
parameter Real T(unit="C")=180 "temperature at which heat of vaporization to be estimated";
//variable section
Real Tr1(unit=" ") "Reduced temperature at normal boiling point";
Real Tr2(unit=" ") "Reduced temperature at 180 degree C";
Real Hv2(unit="cal/g") "Heat of vaporization at 180 degree C";
//equation section
equation
Tr1=(Tn+273.15)/(Tc+273.15);
Tr2=(T+273.15)/(Tc+273.15);
Hv2=Hv*((1-Tr2)/(1-Tr1))^(0.38); 
end Ex8_4;
