//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-8: Thermophysics
  //Example 8.7; Page 283
  //Title: Calculating the enthaply of dry air at 1 atm pressure and 100 degree F
model Ex8_7
parameter Real awd(unit="lb")=0.0215 "amount of water vapor per lb dry air at 1 atm and 100 degree F";
parameter Real dp(unit="F")=79 "dew point of water";
parameter Real T0(unit="F")=32 "Initial temperature of mixture";
parameter Real Tf(unit="F")=100 "final temperature of mixture";
parameter Real Hwv(unit="Btu/(lb-mole*F)")=8.02 "Mean molal heat capacity of water vapor between 79 and 100 degree F";
parameter Real Hw(unit="Btu/(lb*F)")=1 "Mean molal heat capacity of water between 32 and 79 degree F";
parameter Real Ha(unit="Btu/(lb-mole*F)")=6.95 "Mean molal heat capacity of dry air between 32 and 100 degree F";
parameter Real Hv(unit="Btu/lb")=1046 "Latent heat of vaporization of water";
parameter Real MW(unit="g")=18 "Molar mass of water";
parameter Real MA(unit="g")=29 "Molar mass of dry air";
//variable section
Real Ea(unit="Btu") "Sensible enthalpy of air at 100 degree F";
Real Ew(unit="Btu") "Sensible enthalpy of liquid water at 79 degree F";
Real Ewv(unit="Btu") "Sensible enthalpy of water vapor at 100 degree F";
Real E(unit="Btu") "Final enthapy of mixture";
//equation section
equation
Ea=Ha/MA*(Tf-T0);
Ewv=Hwv/MW*awd*(Tf-dp);
Ew=Hw*(dp-T0)*awd;
E=Ea+Ewv+Ew+Hv*awd;
end Ex8_7;
