//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.10; Page 324
  //Title: Calculating final temperature of mixture
model Ex9_10
//parameter section
parameter Real c1(unit=" ")=10 "concentration of 1st solution";
parameter Real c2(unit=" ")=30 "concentration of 2nd solution";
parameter Real E10(unit="Btu/lb")=-60 "enthalpy per pound solution of 10% HCl solution";
parameter Real E30(unit="Btu/lb")=-175 "enthalpy per pound solution of 30% HCl solution";
parameter Real M10(unit="lb")=5 "amount of 10% HCl solution";
parameter Real M30(unit="lb")=8 "amount of 30% HCl solution";
//variable section
Real tE(unit="Btu") "total enthalpy of mixture per pound mixture";
Real fc(unit=" ") "concentration of final mixture";
//equation section
equation
tE=(M10*E10+M30*E30)/(M10+M30);
fc=(M10*c1/100+M30*c2/100)/(M10+M30)*100 "Temperature corresponding to this final concentration and enthalpy is 90 degree F" ;
end Ex9_10;
