  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.8; Page 322
  //Title: Calculating standard heat of solution
model Ex9_8
//parameter section
parameter Real HfC(unit="cal")=-190000 "Heat of formation of CaCl2";
parameter Real HfW(unit="cal")=-68317.4 "Heat of formation of CaCl2";
parameter Real HfCc(unit="cal")=-623150 "Heat of formation of CaCl2.6H2O";
parameter Real mW(unit="g-moles") =10 "amount of water per unit CaCl2 required";
parameter Real HsC(unit="cal")=-15500 "heat of solution for 10 moles of water per mole CaCl2";
//variable section
Real EHc(unit="cal") "Enthalpy change accompanying Hydration by formation of crystal";
Real EHs(unit="cal") "Enthalpy change accompanying Hydration by formation of dilute solution";
//equation section
equation
EHc=HfCc-HfC-6*HfW;
EHs=HsC-EHc;
end Ex9_8;
