//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.4; Page 7
//Title: Finding slope of vapor-pressure curve of water
//==================================
model Ex1_4
//parameter section
parameter Real T[8](unit="F")={32,35,40,45,50,55,60,65} "Temperatures useful for finding slope to be found";
parameter Real P[8](unit="psi")={0.08854,0.09995,0.12170,0.14752,0.17811,0.2141,0.2563,0.3056} "corresponding vapor-presseure values";
//variable section
Real d[7](unit="psi/F") "Slope of pressure-temperature graph";
//algorithm section
algorithm
d[1]:=(P[2]-P[1])/(T[2]-T[1]) "slope at T=32F is assumed to be the slope at mid point of 32F and 35F which results in ~5% deviation from the answer in textbook";
for i in 2:7 loop
d[i]:=(P[i-1]-P[i+1])/(T[i-1]-T[i+1]) "Central difference method is used to evaluate derivatives" ;
end for;
 
end Ex1_4;
