//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.5; Page 9
//Title: Finding Pressure-Volume and Pressure-Temperature relation in reversible-adiabatic process for ideal gas
//==================================

model Ex1_5
//import statement
import Modelica.Math.*;
//parameter section
parameter Real R(unit="L atm/(K mol)")=0.0821 "Universal gas constant";
parameter Real pi(unit="atm")= 1 "initial pressure of air";
parameter Real Ti(unit="R")=800 "initial temperature of air";
parameter Real p[10](unit="atm")={0.01,0.02,0.04,0.06,0.08,0.1,0.2,0.4,0.6,0.8}  "Pressure of air(assumed ideal gas)";
//variable section
Real Vi(unit="cu ft") "initial volume of air";
Real T[10](unit="R (Rankine)") "Temperature of air(assumed ideal gas)";
Real V[10](unit="cu ft") "Volume of air(assumed ideal gas)"; 
Real C1(unit="atm*(cu ft)^1.4") "Constant 1";
Real C2(unit="atm*(R)*(-3.5)") "Constant 2";

//equation
equation
pi*(0.035315*Vi)=R*(5/9*Ti) "Ideal Gas Equation and (Volume Scale)1L=0.035315cu ft and (Temperature scale)K=5/9*R ";
log(pi)=-1.4*log(Vi)+log(C1) "Given Equation";
log(pi)=3.5*log(Ti)+log(C2) "Given Equation";
//algorithm
algorithm
for i in 1:10 loop
(V[i]):=exp((-log(p[i])+log(C1))/1.4);
(T[i]):=exp(-(-log(p[i])+log(C2))/3.5);
end for;
end Ex1_5;
