//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.6; Page 11
//Title: Finding Activation energy and Frequency factor using Arrhenius equation 
// Using least square regression 
//==================================
model Ex1_6
//import section
import Modelica.Math.*;
//parameter section
parameter Real x[6](unit="1/K")={0.003661, 0.003532, 0.003411, 0.003299, 0.003193, 0.003085} "Inverse of  Temperatures at which reaction has taken place" ;
parameter Real k[6](unit="s^(-1)")={1.055*10^(-16),1.070*10^(-15),9.25*10^(-15),6.94*10^(-14),4.58*10^(-13),3.19*10^(-12)} "Specific reaction rate";
parameter Real R(unit="g-cal/((g-mole)(K))")=1.987 "Ideal Gas Constant";
//variable section
Real y[6](unit=" ") "logk";
Real s(unit="K") "Slope of logk v/s 1/T graph";
Real c(unit=" ") "Intercept of logk v/s 1/T graph";
Real d1(unit=" ") "dummy variable";
Real d2(unit=" ") "dummy variable";
Real d3(unit=" ") "dummy variable";
Real d4(unit=" ") "dummy variable";
Real E(unit="g-cal/g-mole") "Activation energy";
Real A(unit=" ") "Arrhenius constant";
//equation
equation
for i in 1:6 loop
y[i]=log(k[i]);
end for;
//algorithm
algorithm
d1:=0;
d2:=0;
d3:=0;
d4:=0;
for i in 1:6 loop
d1:=d1+x[i];
d2:=d2+y[i];
d3:=d3+x[i]*y[i];
d4:=d4+x[i]*x[i];
end for;
s:=(6*d3-d1*d2)/(6*d4-d1*d1) "slope = (N*sum(x*y)-sum(x)*sum(y))/(N*sum(x^2)-sum(x)^2) ";
c:=(d2-s*d1)/6 "intercept= (sum(y)-slope*sum(x))/N";
E:=-R*s;
A:=exp(c);
end Ex1_6;
/*The error in final answer of arrhenius constant and activation energy is due to truncation to 3 decimal places of various variables used in book. The method of least square regression used in code is correct and gives approximately correct results as compared to the book. error in activation energy is=0.49% and error in arrhenius constant is 31%*/
