//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-10:Adsorption
  //Example 10.1; Page 378
  //Title: Calculating value of constants Vm, C, n from the given data
model Ex10_1
//parameter section
parameter Real p[9](unit="mmHg")={21, 45, 90, 175, 245, 330, 405, 485, 540} "Pressure values at data points";
parameter Real V[9](unit="cc/g")={70, 93, 120, 135, 155, 175, 200, 220, 245} "Volume values at data points";
parameter Real ps(unit="mmHg")=1026 "Saturation pressure at T=-183 degree C";
//variable section
Real x[9](unit=" ") "Fraction of Argon in liquid state in corresponding to data values";
Real sum2(unit=" ") "dummy variable";
Real mx(unit=" ") "mean of x's";
Real sum1(unit="cc/g") "dummy variable";
Real y[9](unit="g/cc") "y coordinate of plot ie x/(V*(1-x))";
Real my(unit="g/cc") "mean value of y's";
Real Vm(unit="cc/g") "Volume of gas adsorbed per unit mass of adsorbent to cover surface with one molecule layer thick";
Real C(unit=" ") "Empirical constant";
Real n(unit=" ") "number of layers formed";
Real sum3(unit=" ") "dummy variable";
Real sum5(unit=" ") "dummy variable";

//equation section
equation
for i in 1:9 loop
x[i]=p[i]/ps;
y[i]=x[i]/(V[i]*(1-x[i]));
end for;
algorithm
for i in 1:9 loop
sum1:=sum1+x[i];
sum2:=sum2+y[i];
end for;
equation
mx=sum1/9;
my=sum2/9;
algorithm
for i in 1:9 loop
sum3:=sum3+(x[i]-mx)*(y[i]-my);
sum5:=sum5+(x[i]-mx)^2;
end for;
equation
(C-1)/(Vm*C)=sum3/sum5;
1/(Vm*C)=my-sum3/sum5*mx;
V[1]=(Vm*C*x[1]/(1-x[1]))*(1-(n+1)*x[1]^n+n*x[1]^(n+1))/(1+(C-1)*x[1]-C*x[1]^(n+1));  
end Ex10_1;
