package Ex10_3
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-10:Adsorption
  //Example 10.3; Page 389
  //Title: Calculating heat evolved from integral heat of wetting data

  model Ex10_3_a
    //parameter section
    parameter Real ba(unit = "lb") = 100 "amount of dry silica gel as basis";
    parameter Real wi(unit = "lb") = 5 "content of water initially";
    parameter Real wf(unit = "lb") = 20 "content of water finally";
    parameter Real Ei(unit = "Btu/lb") = -18 "Enthalpy per lb of dry silica gel of silica gel+water at initial concentration";
    parameter Real Ef(unit = "Btu/lb") = -46 "Enthalpy per lb of dry silica gel of silica gel+water at final concentration";
    //variable section
    Real Ec(unit = "Btu") "enthalpy change";
    //equation section
  equation
    Ec = ba * (Ef - Ei);
  end Ex10_3_a;

  //Title: Calculating heat evolved from differential heat of wetting data
  model Ex10_3_b
   //parameter section
    parameter Real ba(unit = "lb") = 100 "amount of dry silica gel as basis";
    parameter Real wi(unit = "lb") = 5 "content of water initially";
    parameter Real wf(unit = "lb") = 20 "content of water finally";
    parameter Real Esi(unit = "Btu/lb") = -5 "Enthalpy per lb dry silica gel at initial concentration";
    parameter Real Ewi(unit = "Btu/lb") = -260 "Enthalpy per lb water at initial concentration";
    parameter Real Ewf(unit = "Btu/lb") = -100 "Enthalpy per lb water at final concentration";
    parameter Real Esf(unit = "Btu/lb") = -26 "Enthalpy per lb dry silica gel at final concentration";
    //variable section
    Real Ec(unit = "Btu") "enthalpy change";
    //equation section
  equation
    Ec = ba * (Esf-Esi+wf/ba*Ewf-wi/ba*Ewi);
  
  end Ex10_3_b;



end Ex10_3;
