package Ex11_2
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-11:Fuels and Combustion
  //Example 11.2; Page 410
  //Title: Calculating the theoretical amount of oxygen required for complete combustion

  model Ex11_2_a
    //parameter section
    parameter Real ba(unit = "g-moles") = 1 "Amount of gas as basis";
    parameter Real pCO2(unit = " ") = 2.6 "percent of CO2 in gas";
    parameter Real pC2H4(unit = " ") = 8.4 "percent of C2.73H4.72 (unsaturateds) in gas";
    parameter Real pO2(unit = " ") = 0.7 "percent of O2 in gas";
    parameter Real pH2(unit = " ") = 39.9 "percent of H2 in gas";
    parameter Real pCO(unit = " ") = 32.9 "percent of CO in gas";
    parameter Real pCH4(unit = " ") = 10.1 "percent of C1.14H4.28 parrafin in gas";
    parameter Real pN2(unit = " ") = 5.4 "percent of N2 in gas";
    parameter Real aOC(unit = " ") = 1 "moles of O2 required for combustion of 1 mole C";
    parameter Real aOH(unit = " ") = 0.25 "molecules of O2 required for combustion of 1 atom H";
    //vraiable Section
    Real aOrC2H4(unit = "moles") "Amount of O2 required for combustion of C2.73H4.72 (unsaturateds)";
    Real aOrH2(unit = "moles") "Amount of O2 required for combustion of H2";
    Real aOrCO(unit = "moles") "Amount of O2 required for combustion of CO";
    Real aOrCH4(unit = "moles") "Amount of O2 required for combustion of C1.14H4.28";
    Real atOr(unit = "moles") "Amount of total Oxygen required for combustion";
    //equation section
  equation
    aOrC2H4 = ba * pC2H4 / 100 * (2.73 * aOC + 4.72 * aOH);
    aOrH2 = ba * pH2 / 100 * (aOH * 2);
    aOrCO = ba * pCO / 100 / 2 "CO requires only 0.5 moles of O2 per mole CO for complete combustion";
    aOrCH4 = ba * pCH4 / 100 * (aOC * 1.14 + 4.28 * aOH);
    atOr + pO2 / 100 = aOrC2H4 + aOrH2 + aOrCO + aOrCH4;
  end Ex11_2_a;

  //Title: Calculating heating value of gas
  model Ex11_2_b
  //parameter section
    parameter Real ba(unit = "g-moles") = 1 "Amount of gas as basis";
    parameter Real pCO2(unit = " ") = 2.6 "percent of CO2 in gas";
    parameter Real pC2H4(unit = " ") = 8.4 "percent of C2.73H4.72 (unsaturateds) in gas";
    parameter Real pO2(unit = " ") = 0.7 "percent of O2 in gas";
    parameter Real pH2(unit = " ") = 39.9 "percent of H2 in gas";
    parameter Real pCO(unit = " ") = 32.9 "percent of CO in gas";
    parameter Real pCH4(unit = " ") = 10.1 "percent of C1.14H4.28 parrafin in gas";
    parameter Real pN2(unit = " ") = 5.4 "percent of N2 in gas";
    parameter Real hH2(unit="cal/g-mole")=68317 "Heating value of Hydrogen";
    parameter Real hCO(unit="cal/g-mole")=67636 "Heating value of CO";
    parameter Real c1(unit=" ")=385.2 "385.2scf=1lb-moles";
    parameter Real c2(unit=" ")=1.8 "1.8Btu/lb-mole=cal/g-mole";
    //variable section
    Real hH2g(unit="Btu/cuft") "Heating value of H2 in gas";
    Real hCOg(unit="cal") "Heating value of CO in gas";
    Real hC2H4g(unit="cal") "Heating value of C2.73H4.72 (unsaturateds) in gas";
    Real hCH4g(unit="cal") "Heating value of C1.14H4.28 parrafin in gas";
    Real thg(unit="cal") "Total heating value of gas";
    //equation section
    equation
    hH2g=ba*pH2/100*hH2;
    hCOg=ba*pCO/100*hCO;
    hC2H4g=ba*pC2H4/100*(2.73*98200+4.72*28200+28800);
    hCH4g=ba*pCH4/100*(1.14*158100+54700);
    thg=(hH2g+hCOg+hC2H4g+hCH4g)/c2*c1;
  end Ex11_2_b;












end Ex11_2;
