model Ex11_3
//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-11:Fuels and Combustion
  //Example 11.3; Page 411
  //Title: Calculating the standard heat of reaction
  //parameter section
  parameter Real ba(unit="lb-mole")=1 "Amount of flue gas as basis";
  parameter Real pCO2(unit=" ")=12.4 "percent of CO2 in gas mixture";
  parameter Real pCO(unit=" ")=1.2 "percent of CO in gas mixture";
  parameter Real pO2(unit=" ")=5.4 "percent of O2 in gas mixture";
  parameter Real pN2(unit=" ")=81 "percent of N2 in gas mixture";
  parameter Real pCC(unit=" ")=68.1 "percent of carbon in coal";
  parameter Real MC(unit="g")=12 "Molar mass of Carbon";
  parameter Real hCl(unit="Btu/lb")=-12180 "heating value of coal per lb";
  parameter Real hCCO(unit="cal/g-mole")=-67636 "Heat of combustion of CO";
  parameter Real c1(unit=" ")=1.8 "1cal/g-mole=1.8Btu/lb-mole";
  //variable section
  Real tC(unit="lb") "Total amount of carbon";
  Real tCo(unit="lb") "Total amount of coal";
  Real hC(unit="Btu") "heating value of coal";
  Real nhCCO(unit="Btu") "net heat of combustion of CO in Btu";
  Real sh(unit="Btu") "standard heat of reaction";
  //equation section
  equation
  tC=ba*(pCO2/100+pCO/100)*MC;
  tCo=tC/(pCC/100);
  hC=hCl*tCo;
  nhCCO=pCO/100*hCCO*c1;
  sh=hC-nhCCO;
end Ex11_3;
