//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-11:Fuels and Combustion
  //Example 11.6; Page 433
  //Title: Applying material and energy balance for operation of gas producer
model Ex11_6
//parameter section
parameter Real ba(unit="lb")=100 "amount of coal charged";
parameter Real ba2(unit="cuft")=1000 "volume of wet gas at 1075 degree F and 29.75 in.Hg";
parameter Real ba3(unit="lb-mole")=1 "amount of dry gas as basis";
parameter Real acc(unit="lb")=70900 "amount of coal used";
parameter Real adt(unit="lb")=591 "amount of tar deposited for 70900lb coal used";
parameter Real pCC(unit=" ")=66.31 "percent of carbon in coal";
parameter Real pCt(unit=" ")=93 "percent of carbon in tar deposited";
parameter Real pac(unit=" ")=4.58 "percent of ash as weighed in coal";
parameter Real par(unit=" ")=95.82 "percent of ash in refuse";
parameter Real pcr(unit=" ")=3.08 "percent of carbon in refuse";
parameter Real Tw(unit="F")=1075 "temp of wet gas";
parameter Real Tf(unit="F")=75 "Reference temp";
parameter Real Tr(unit="F")=350 "Temp of refuse";
parameter Real Pw(unit="in.Hg")=29.75 "Pressure of wet gas";
parameter Real MW(unit="g")=18 "molar mass of water";
parameter Real pwh(unit="grains/cuft")=3.43 "amount of water vapor in hot gas";
parameter Real pth(unit="grains/cuft")=3.31 "amount of tar in hot gas";
parameter Real psh(unit="grains/cuft")=1.52 "amount of soot in hot gas";
parameter Real c1(unit=" ")=7000 "1lb=7000 grains";
parameter Real pCO2d(unit=" ")=7.12 "percent by volume of CO2 in dry gas";
parameter Real pCOd(unit=" ")=21.85 "percent by volume of CO in dry gas";
parameter Real pO2d(unit=" ")=0.9 "percent by volume of O2 in dry gas";
parameter Real pCH4d(unit=" ")=3.25 "percent by volume of CH4 in dry gas";
parameter Real pH2d(unit=" ")=13.65 "percent by volume of H2 in dry gas";
parameter Real pN2d(unit=" ")=53.24 "percent by volume of N2 in dry gas";
parameter Real MCO2(unit="g")=44 "molar mass of CO2";
parameter Real MCO(unit="g")=28 "molar mass of CO";
parameter Real MO2(unit="g")=32 "molar mass of O2";
parameter Real MCH4(unit="g")=16 "molar mass of CH4";
parameter Real MH2(unit="g")=2 "molar mass of H2";
parameter Real MN2(unit="g")=28 "molar mass of N2";
parameter Real MC(unit="g")=12 "molar mass of C";
parameter Real pCst(unit=" ")=90 "percent of C in suspended tar";
parameter Real pN2c(unit=" ")=1.52 "percent of N2 in coal";
parameter Real mha(unit=" ")=0.023 "molal humidity of air";
parameter Real phc(unit= " ")=3.53 "amount of H2 in coal";
parameter Real pwc(unit= " ")=23.16 "amount of H2O in coal";
parameter Real MA(unit="g")=29 "molar mass of dry air";
parameter Real Hvc(unit="Btu/lb")=11910 "heating value of coal per lb";
parameter Real Esi(unit="Btu/lb")=1127 "Enthalpy of steam per lb at input conditions";
parameter Real Ewa(unit="Btu/lb")=1052 "Enthalpy of water vapor in air";
parameter Real hvpg(unit="Btu")=792200 "heating value of dry clean producer gas";
parameter Real hvst(unit="Btu/lb")=16000 "heating valur of suspended tar";
parameter Real hvs(unit="cal/g")=96650 "heating value of soot";
parameter Real c2(unit=" ")=1.8 "1cal/g-mole=1.8 Btu/lb-mole";
parameter Real hvdt(unit="Btu/lb")=15500 "heating value of tar deposited";
parameter Real shcCO2(unit="Btu/(lb-mole*R)")=11 "specific heat capacity of CO2";
parameter Real shcCO(unit="Btu/(lb-mole*R)")=7.27 "specific heat capacity of CO";
parameter Real shcO2(unit="Btu/(lb-mole*R)")=7.6 "specific heat capacity of O2";
parameter Real shcN2(unit="Btu/(lb-mole*R)")=7.22 "specific heat capacity of N2";
parameter Real shcH2(unit="Btu/(lb-mole*R)")=7.01 "specific heat capacity of H2";
 parameter Real shcCH4(unit="Btu/(lb-mole*R)")=12.15 "specific heat capacity of CH4";
parameter Real shcts(unit="Btu/(lb-mole*R)")=0.32 "specific heat capacity of tar and soot";
parameter Real Hvw(unit="Btu/lb-mole")=18948 "heat of vaporization of water";
parameter Real shcw(unit="Btu/(lb-mole*R)")=8.65 "specific heat capacity of H2O";
parameter Real shcr(unit="Btu/(lb-mole*R)")=0.22 "specific heat capacity of refuse";

//variable section
Real mCC(unit="lb") "Mass of carbon in coal";
Real mCt(unit="lb") "mass of coal in deposited tar";
Real wr(unit="lb") "weight of refuse";
Real mcr(unit="lb") "amount of carbon in refuse";
Real mcg(unit="lb") "amount of carbon gasified";
Real mwg(unit="lb-mole") "moles of wet gas according to ba2";
Real mwp(unit="lb-mole") "amount of water present in wet gas according to ba2"; 
Real mdg(unit="lb-mole") "amount of dry gas according to ba2";
Real awp(unit="lb-moles") "amount of water vapor present according to ba3";
Real atp(unit="lb-moles") "amount of tar present according to ba3";
Real asp(unit="lb-moles") "amount of soot present according to ba3";
Real tcd(unit="lb-mole") "total carbon in 1lb-mole dry gas ";
Real mdgf(unit="lb-mole") "amount of dry gas according to ba";
 Real aCO2d(unit=" ") "amount of CO2 in 100 lb coal";
Real aCOd(unit=" lb-mole") "amount of CO in 100lb coal";
 Real aO2d(unit="lb-mole ") "amount  of O2 in 100lb coal";
 Real aCH4d(unit="lb-mole ") "amount of CH4 in 100lb coal";
 Real aH2d(unit="lb-mole ") "amount of H2 in 100lb coal";
 Real aN2d(unit="lb-mole ") "amount of N2 in 100lb coal";
 Real awvw(unit="lb-moles") "amount of water vapor in wet gas";
 Real act(unit="lb-mole") "amount of carbon in tar per 100lb coal";
 Real aht(unit="lb-mole") "amount of H2 in tar per 100lb coal";
 Real acs(unit="lb-moles") "amount of carbon in soot";
 Real aN2t(unit="lb-mole") "amount of N2 from air";
 Real ads(unit="lb-mole") "amount of dry air supplied";
 Real awa(unit="lb-mole") "amount of water in air";
 Real aho(unit="lb-mole") "amount of H2 in output";
 Real ahi(unit="lb-mole") "amount of H2 in input";
 Real asi(unit="lb-mole") "amount of steam introduced";
 Real tmi(unit="lb") "total mass input";
 Real tmo(unit="lb") "total mass output";
 Real hvc(unit="Btu") "total heating value of coal";
 Real esi(unit="Btu") "enthalpy of steam input";
 Real ewa(unit="Btu") "Enthalpy of water vapor in air";
 Real tei(unit="Btu") "total energy input";
 Real teo(unit="Btu") "total energy output";
 Real er(unit="Btu") "energy not accounted for";
//equation section
equation
mCC=ba*pCC/100;
mCt=adt/acc*ba*pCt/100;
wr=pac/100*ba/(par/100);
mcr=pcr/100*wr;
mcg=mCC-mCt-mcr;
mwg=ba2/(359*(((Tw-32)*5/9+273.15)*9/5)*29.92/(492*Pw));
mwp=pwh*ba2/(c1*MW);
mdg=mwg-mwp;
awp=mwp/mdg*ba3;
atp=pth*ba2/(c1*mdg);
asp=psh*ba2/(c1*mdg);
tcd=pCO2d/100+pCOd/100+pCH4d/100+asp/MC+atp/MC*pCst/100;
mdgf=mcg/tcd/MC;
aCO2d=mdgf*pCO2d/100;
aCOd=mdgf*pCOd/100;
aO2d=mdgf*pO2d/100;
aCH4d=mdgf*pCH4d/100;
aN2d=mdgf*pN2d/100;
aH2d=mdgf*pH2d/100;
awvw=mdgf*awp;
act=mdgf*atp*pCst/100/MC;
aht=mdgf*atp*(1-pCst/100)/MH2;
acs=mdgf*asp;
aN2t=aN2d+pN2c/100*ba/MN2;
ads=aN2t/0.79;
awa=mha*ads;
aho=adt/acc*ba*(1-pCt/100)+aH2d+aCH4d*2+awvw+aht;
ahi=asi+phc/100*ba/MH2+pwc*ba/100/MW+awa;
aho=ahi;
tmi=ba+ads*MA+awa*MW+asi*MW;
tmo=wr+adt/acc*ba+asp*mdgf+atp*mdgf+aCO2d*MCO2+aCOd*MCO+aO2d*MO2+aCH4d*MCH4+aH2d*MH2+aN2d*MN2+awvw*MW;
/* Energy Balance */
hvc=ba*Hvc;
esi=Esi*asi*MW;
ewa=Ewa*awa*MW;
tei=hvc+esi+ewa;
teo=hvpg+hvst*atp*mdgf+hvs*c2*(asp*mdgf/MC+mcr/MC)+hvdt*adt/acc*ba+(aCO2d*shcCO2+aCOd*shcCO+aO2d*shcO2+aN2d*shcN2+aH2d*shcH2+aCH4d*shcCH4)*(Tw-Tf)+(adt/acc*ba+asp*mdgf+atp*mdgf)*(Tw-Tf)*shcts+awvw*(Hvw+shcw*(Tw-Tf))+wr*shcr*(Tr-Tf);
er=tei-teo;
end Ex11_6;
