//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-2:Stoichometric and composition Relationships
//Example 2.4; Page 36
//Title: Expressing composition in mole per cent from w/w%
model Ex2_4
//parameter section
parameter Real ba(unit="g")=100 "basis i.e. weight of solution";
parameter Real ww(unit=" ")=40 "w/w% of Na2CO3 in aqueous solution";
parameter Real MN(unit="g")=106 "Molar mass of Na2CO3";
parameter Real MW(unit="g")=18.02 "Molar mass of water";
//variable section
Real wN(unit="g") "weight of Na2CO3";
Real wW(unit="g") "weight of H2O"; 
Real nN(unit="moles") "number of moles of Na2CO3";
Real nW(unit="moles") "number of moles of water";
Real xN(unit=" ") "mole percent of Na2CO3 in solution";
Real xW(unit=" ") "mole percent of water in solution"; 
//equation section
equation
wN=ba*ww/100;
wW=ba*(1-ww/100);
nN=wN/MN;
nW=wW/MW;
xN=(nN/(nN+nW))*100;
xW=(nW/(nW+nN))*100;
end Ex2_4;
