package Ex2_6
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-2:Stoichometric and composition Relationships
  //Example 2.6; Page 37
  //Title: Finding composition in mole per cent

  model Ex2_6_a
    //parameter section
    parameter Real ba(unit = "lb-mole") = 100 "basis total moles";
    parameter Real vM(unit = " ") = 83.5 "Volumetric percent composition of Methane";
    parameter Real vE(unit = " ") = 12.5 "Volumetric percent composition of Ethane";
    parameter Real vN(unit = " ") = 4 "Volumetric percent composition of Nitrogen";
    //variable section
    Real xM(unit = "lb-mole ") "mole of Methane";
    Real xE(unit = "lb-mole ") "mole of Ethane";
    Real xN(unit = "lb-mole ") "mole of Nitrogen";
    //equation section
  equation
/*On assuming all 3 gases as ideal gas and all 3 are at same temp and pressure, the molar composition of all 3 gases are same as volumetric compostion by ideal gas equation as V/n is constant for all gases. Thus,*/
    xM = vM;
    xE = vE;
    xN = vN;
  end Ex2_6_a;



  /*Uses the results of mole percent from Ex2_6_a*/
  model Ex2_6_b
  extends Ex2_6_a;
  //parameter section
  parameter Real MM(unit="g")=16.03 "Molar mass of methane";
  parameter Real ME(unit="g")=30.05 "Molar mass of Ethane";
  parameter Real MN(unit="g")=28.02 "Molar mass of Nitrogen";
  //variable section
  Real mM(unit="lb") "mass of Methane";
  Real mE(unit="lb") "mass of Ethane";
  Real mN(unit="lb") "mass of Nitrogen";
  Real yM(unit=" ") "mass percent of Methane";
  Real yE(unit=" ") "mass percent of Ethane";
  Real yN(unit=" ") "mass percent of Nitrogen";
  //equation section
  equation 
  mM=MM*(xM/100)*ba;
  mE=ME*(xE/100)*ba;
  mN=MN*(xN/100)*ba;
  yM=(mM/(mM+mE+mN))*100;
  yE=(mE/(mM+mE+mN))*100;
  yN=(mN/(mM+mE+mN))*100;
    end Ex2_6_b;





  /* Uses data of mass from Ex2_6_b*/
model Ex2_6_c
extends Ex2_6_b;
//variable section
Real M(unit="lb") "Molar mass of solution";
//equation section
equation
M=(mM+mE+mN)/ba;
end Ex2_6_c;



  model Ex2_6_d
  extends Ex2_6_c;
  //parameter section
  parameter Real v(unit="cu ft")=359 "Volume occupied by 1 lb-mole of any gas at standard conditions";
  //variable section
  Real V(unit="cu ft") "Total volume of natural gas as per basis";
  Real D(unit="lb/(cu ft)") "Density of natural gas at standard conditions";
  //equation section
  equation
  V=v*ba;
  D=(M*ba)/V;
  end Ex2_6_d;




  
  
  





end Ex2_6;
