//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.1; Page 54
  //Title: Finding Volume occupied by an ideal gas(Chlorine(Cl2)) using ideal gas equation
model Ex3_1
//parameter section
parameter Real P(unit="mm Hg")=743 "Pressure of Cl2";
parameter Real T(unit="F")=70 "Temperature of Cl2";
parameter Real m(unit="lb")=30 "mass of Cl2 gas";
parameter Real M(unit="g")=71 "Molar mass of Cl2";
parameter Real c1(unit=" ")=7.60*10^(-3)/1.01325 "1Pa=7.60*10^(-3)mmHg";
parameter Real c2(unit=" ")=453.592 "1lb=453.592g";
parameter Real R(unit="J/(mole*K)")=8.314 "universal gas constant";
//variable section
Real V(unit="m^3") "Volume occupied by Cl2 at 743mmHg pressure and 70 degreeF temperature";
Real n(unit="moles") "number of moles of Cl2 present in 30lb Cl2";
//equation section
equation
n=(m*c2)/M;
(P/c1)*V=n*R*((T-32)*(5/9)+273.15) "Temperature is converted to K sclae from F scale;Pressure is converted to Pa from mmHg;4.79619m^3=169.376cuft";
end Ex3_1;
