package Ex3_10
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.10; Page 62
  //Title: Calculating the volume of gas leaving,volume composition,weight of HCl absorbed per 100cuft gas entering absorption apparatus

  model Ex3_10_a
    //parameter section
    parameter Real ba(unit = "cu ft") = 100 "Basis of calculation";
    parameter Real vvH(unit = " ") = 25 "v/v% of HCl";
    parameter Real vvA(unit = " ") = 75 "v/v% of Air";
    parameter Real aH(unit = " ") = 98 "percent of HCl absorbed";
    parameter Real Ti(unit = "F") = 120 "Temperature before gases enter evaporator";
    parameter Real Tf(unit = "F") = 80 "Temperature after gases enter evaporator";
    parameter Real Pi(unit = "mmHg") = 743 "Pressure before gases enter evaporator";
    parameter Real Pf(unit = "mmHg") = 738 "Pressure after gases exit evaporator";
    parameter Real R(unit = "J/(mole*K)") = 8.314 "Universal gas constant";
    parameter Real c1(unit = " ") = 7.60 * 10 ^ (-3) / 1.01325 "1Pa=7.60*10^(-3)/1.01325mmHg";
    parameter Real c2(unit = " ") = 35.315 "1m^3=35.315cu ft";
    //variable section
    Real v(unit = "cu ft") "volume of gas leaving absorptionn system";
    Real viH(unit = "cu ft") "volume of HCl entering absorption system";
    Real vfH(unit = "cu ft") "volume of HCl leaving absorption system";
    Real vA(unit = "cu ft") "volume of air entering absorption system";
    //equation section
  equation
    viH = vvH / 100 * ba;
    vA = vvA / 100 * ba;
    vfH = viH * (1 - aH / 100);
    v = vfH + vA;
  end Ex3_10_a;

  model Ex3_10_b
  /*Uses the value of volume from Ex3_10_a*/  
  extends Ex3_10_a;
  //variable section
  Real vpH(unit=" ") "percent composition volume of HCl";
  Real vpA(unit=" ") "percent composition volume of air"; 
  //equation section
  equation
  vpH=vfH/v*100;
  vpA=vA/v*100;
  end Ex3_10_b;


  model Ex3_10_c
  /*Uses the parameters from Ex3_10_a*/
  extends Ex3_10_b;
  //parameter section
  parameter Real MH(unit="g")=36.5 "Molar mass of HCl";
  //variable section
  Real nfH(unit="moles") "Number of moles of HCl leaving absorption system";
  Real niH(unit="moles") "Number of moles of HCl entering the absorption system";
  Real wH(unit="g") "weight of HCl removed";
  //equation section
  equation
  (Pf/c1)*(vfH/c2)=nfH*R*(((Tf-32)*5/9)+273.15);
  (Pi/c1)*(viH/c2)=niH*R*(((Ti-32)*5/9)+273.15);
  wH=(niH-nfH)*MH "935.578g=2.06lb";
  end Ex3_10_c;






end Ex3_10;
