package Ex3_12
//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.12; Page 65
  //Title: Calculating the properties of air, gases in process

  model Ex3_12_a
    //parameter section
    parameter Real ba(unit = "cu ft") = 100 "Basis of calculation i.e. initial volume of NH3 entering";
    parameter Real Ti(unit = "C") = 20 "Temperature of air and NH3 entering process";
    parameter Real Pi(unit = "mmHg") = 755 "Pressure of air and NH3 entering process";
    parameter Real ex(unit = " ") = 20 "excess amount of O2 needed";
    parameter Real Tf(unit = "C") = 700 "Temperature of air and NH3 leaving process";
    parameter Real Pf(unit = "mmHg") = 743 "Pressure of air and NH3 leaving process";
    parameter Real R(unit = "J/(mole*K)") = 8.314 "Universal gas constant";
    parameter Real c1(unit = " ") = 7.60 * 10 ^ (-3) / 1.01325 "1Pa=7.60*10^(-3)/1.01325mmHg";
    parameter Real c2(unit = " ") = 35.315 "1m^3=35.315cu ft";
    parameter Real OA(unit = " ") = 21 "percent of oxygen in air";
    //variable section
    Real vOc(unit = "cu ft") "volume of O2 required for exact complete oxidation";
    Real vOa(unit = "cu ft") "Actual volume of O2 required";
    Real vAa(unit = "cu ft") "Actual volume of air required";
    //equation section
  equation
    vOc = ba * 2 "Overall Equation is: NH3+2O2-->HNO3+H2O thus for 1 mole of N2,2 moles of O2 will be used";
    vOa = vOc * (1 + ex / 100);
    vAa = vOa * (100 / OA);
  end Ex3_12_a;

  model Ex3_12_b
  extends Ex3_12_a;
  //variable section
  Real vpO(unit=" ") "Volume percent composition of O2 entering catalyzer";
  Real vpN(unit=" ") "Volume percent composition of NH3 entering catalyzer";
  Real vpN2(unit=" ") "Volume percent composition of N2 entering catalyzer";
  //equation section
  equation
  vpO=vOa/(vAa+ba)*100;
  vpN=ba/(vAa+ba)*100;
  vpN2=(vAa-vOa)/(vAa+ba)*100;
  end Ex3_12_b;

  model Ex3_12_c
  extends Ex3_12_b;
  //parameter section
 parameter Real prc(unit=" ")=85 "Percent complete reaction";
  //variable section
  Real niNH(unit="moles") "number of moles of NH3 input";
  Real niO(unit="moles") "number of moles of O2 input";
  Real niN2(unit="moles") "number of moles of N2 input";
  Real nfNH(unit="moles") "number of moles of NH3 output";
  Real nfO(unit="moles") "number of moles of O2 output";
  Real nfN2(unit="moles") "number of moles of N2 output";
  Real nfNO(unit="moles") "number of mole NO formed";
  Real nfW(unit="moles") "number of moles of water formed";
  Real vfNH(unit="cu ft") "volume of NH3 coming out of catalyzer";
  Real vfO(unit="cu ft") "volume of O2 coming out of catalyzer";
  Real vfN2(unit="cu ft") "volume of N2 coming out of catalyzer";
  Real vfNO(unit="cu ft") "volume of NO coming out of catalyzer";
  Real vfW(unit="cu ft") "volume of H2O coming out of catalyzer";
  Real vpfNH(unit=" ") "volume composition of NH3 coming out of catalyzer";
  Real vpfO(unit=" ") "volume composition of O2 coming out of catalyzer";
  Real vpfN2(unit=" ") "volume composition of N2 coming out of catalyzer";
  Real vpfNO(unit=" ") "volume composition of NO coming out of catalyzer";
  Real vpfW(unit=" ") "volume composition of H2O coming out of catalyzer"; 
  //equation section
  equation
  (Pi/c1)*(ba/c2)=niNH*R*(Ti+273.15);
  (Pi/c1)*(vOa/c2)=niO*R*(Ti+273.15);
  (Pi/c1)*((vAa-vOa)/c2)=niN2*R*(Ti+273.15);
  nfNH=niNH*(1-prc/100);
  nfO=niO-(niNH*prc/100)*(5/4);
  nfN2=niN2;
  nfNO=niNH*prc/100;
  nfW=(niNH*prc/100)*(6/4);
  (Pf/c1)*(vfNH/c2)=(nfNH)*R*(Tf+273.15);
  (Pf/c1)*(vfO/c2)=nfO*R*(Tf+273.15);
  (Pf/c1)*(vfN2/c2)=nfN2*R*(Tf+273.15);
  (Pf/c1)*(vfNO/c2)=nfNO*R*(Tf+273.15);
  (Pf/c1)*(vfW/c2)=nfW*R*(Tf+273.15);
  vpfNH=vfNH/(vfNH+vfO+vfN2+vfNO+vfW);
  vpfO=vfO/(vfNH+vfO+vfN2+vfNO+vfW);
  vpfN2=vfN2/(vfNH+vfO+vfN2+vfNO+vfW);
  vpfW=vfW/(vfNH+vfO+vfN2+vfNO+vfW);
  vpfNO=vfNO/(vfNH+vfO+vfN2+vfNO+vfW);
  end Ex3_12_c;








  model Ex3_12_d
  extends Ex3_12_c;
  //variable section
  Real V(unit="cu ft") "Total volume of gases leaving catalyzer";
  //equation section
  equation
  V=vfNO+vfW+vfN2+vfNH+vfO;
  end Ex3_12_d;

model Ex3_12_e
extends Ex3_12_d;
//parameter section
parameter Real pro(unit=" ")=90 "percent NO oxidized to HNO3";
parameter Real MNO(unit="g")=30 "Molar mass of NO";
parameter Real MHNO(unit="g")=63 "Molar mass of HNO3";
//variable section
Real nHNO(unit="g") "moles of HNO3 produced";
Real wHNO(unit="g") "amount of HNO3 produced";
//equation section
equation
nHNO=nfNO*pro/100;
wHNO=nHNO*MHNO "5636.28g=12.42lb";
end Ex3_12_e;

























end Ex3_12;
