//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.8; Page 60
  //Title: Finding density of air
model Ex3_8
//parameter section
parameter Real ba(unit="mole")=1 "Basis of calculation";
parameter Real vN(unit=" ")=79 "volume percent of N2";
parameter Real vO(unit=" ")=21 "volume percent of O2";
parameter Real T(unit="F")=70 "Temperature in F scale";
parameter Real P(unit="mmHg")=741 "Pressure of mixture";
parameter Real c1(unit=" ")=7.60*10^(-3)/1.01325 "1Pa=7.60*10^(-3)/1.01325mmHg";
parameter Real R(unit="J/(mole*K)")=8.314 "Universal gas constant";
parameter Real MO2(unit="g")=32 "Molar mass of O2";
parameter Real MN2(unit="g")=28 "Molecular weight of N2";
//variable section
Real nN(unit="moles") "number of moles of N2";
Real nO(unit="moles") "number of moles of O2";
Real mN(unit="g") "mass of N2"; 
Real mO(unit="g") "mass of O2"; 
Real d(unit="g/L") "density of air";
Real v(unit="L") "Volume occupied by air";
//equation section
equation
(P/c1)*(v/1000)=ba*R*(((T-32)*5/9)+273.15) "Kelvin=((Farheneit-32)*5/9)+273.15";
nN=ba*vN/100;
nO=ba*vO/100;
mN=MN2*nN;
mO=MO2*nO;
d=(mO+mN)/v;
end Ex3_8;
