//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-4:Vapor Pressures
  //Example 4.3; Page 90
//Title: Estimating critical properties of chlorobenzene  
model Ex4_3
//import section
import Modelica.Math.*;
//parameter section
parameter Real Tb(unit="K")=405.2 "normal boiling temperature";
parameter Real Lb(unit="kcal/g-mole")=8.735 "Latent heat of vaporization at normal boiling point";
parameter Real M(unit="K")=112.5 "Molar mass of chlorobenzene";
parameter Real R(unit="J/(mole*K)")=8.314 "universal gas constant";
parameter Real dTE1(unit=" ")=0.011 "Temperature contribution of one ethylene group connected to one atom other than hydrogen in ring";
parameter Real dTE2(unit=" ")=0.011 "Temperature contribution of one ethylene group connected to two atom other than hydrogen in ring";
parameter Real dTCl(unit=" ")=0.017 "Temperature contribution of chloride group in ring";
parameter Real Tcon(unit=" ")=0.567 "Temperature constant of equation";
parameter Real dpE1(unit=" ")=0.154 "pressure contribution of one ethylene group connected to one atom other than hydrogen in ring";
parameter Real dpE2(unit=" ")=0.154 "pressure contribution of one ethylene group connected to two atom other than hydrogen in ring";
parameter Real dpCl(unit=" ")=0.320 "pressure contribution of chloride group in ring";
parameter Real Pcon(unit="(g/atm)^(0.5)")=0.34 "Pressure constant of equation";
parameter Real dvE1(unit=" ")=37 "volume contribution of one ethylene group connected to one atom other than hydrogen in ring";
parameter Real dvE2(unit=" ")=36 "volume contribution of one ethylene group connected to two atom other than hydrogen in ring";
parameter Real dvCl(unit=" ")=49 "volume contribution of chloride group in ring";
parameter Real vcon(unit="cc")=40 "volume constant of equation";
parameter Real c1(unit="atm/Pa")=101325 "1atm=101325Pa";
parameter Real c2(unit="m^3/cc")=10^6 "1m^3=10^6cc";
//variable section
Real sdT(unit=" ") "Sum of delta T of all groups in chlorobenzene";
Real sdp(unit=" ") "Sum of delta P of all groups in chlorobenzene";
Real sdv(unit=" ") "Sum of delta v of all groups in chlorobenzene";
Real Tc(unit="K") "critical temperature of chlorobenzene";
Real Pc(unit="atm") "critical pressure of chlorobenzene";
Real vc(unit="cc/g-mole") "critical volume of chlorobenzene";
Real zcc "critical compressibility factor calculated using critical temp, Pressure, Volume";
Real zcL "critical compressibility factor calculated using critical Latent heat of vaporization";
//equation section
equation
sdT=dTE1*5+dTE2+dTCl;
sdp=dpE1*5+dpE2+dpCl;
sdv=dvE1*5+dvE2+dvCl;
Tb/Tc=Tcon+sdT-sdT^2;
(M/Pc)^(0.5)=Pcon+sdp;
vc=vcon+sdv;
zcc=(Pc*c1)*(vc/c2)/(R*Tc);
zcL=1/(3.43+0.0067*Lb^2);
end Ex4_3;
