//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-4:Vapor Pressures
//Example 4.5; Page 96
//Title: Estimating vapor pressure of n-propylamine at 0 degree C 
model Ex4_5
//import section
import Modelica.Math.*;
//parameter section
parameter Real Tb(unit="C")=48.7 "normal boiling point of n-prop";
parameter Real Pb(unit="atm")=1 "Pressure at which normal boiling point is measured";
parameter Real T1(unit="C")=0 "Temperature at which vapor pressure to be found";
parameter Real bd(unit=" ")=0.133 "Vapor pressure constant b' from graph";
parameter Real db(unit=" ")=0.12 "Vapor pressure constant delta b of amines from table";
parameter Real Tc(unit="K")=497 "Critical temperature of n-propylamine";
parameter Real Pc(unit="atm")=46.8 "Critical pressure of n-prop";

//variable section
Real b(unit=" ") "Vapor Pressure constant";
Real Tr1(unit=" ") "Reduced temperature at normal boiling conditions";
Real Pr1(unit=" ") "Reduced pressure at normal boiling conditions";
Real A(unit=" ") "Vapor pressure constant";
Real Tr2(unit=" ") "Reduced temperature at 0 degree C";
Real Pr2(unit=" ") "Reduced pressure at 0 degree C";
Real P1(unit="atm") "Vapor pressure at 0 degree C";
//equation section
equation
b=bd+db;
Tr1=(Tb+273.15)/Tc;
Pr1=Pb/Pc;
-A*(1-Tr1)/Tr1=log10(Pr1)+exp(-20*(Tr1-b)^2);
Tr2=(T1+273.15)/Tc;
log10(Pr2)=(-A*(1-Tr2)/Tr2)-exp(-20*(Tr2-b)^2);
P1=Pr2*Pc ".112139atm= 85.22mmHg";
end Ex4_5;
