package Ex5_1
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-5:Humidity and Saturation
//Example 5.1; Page 111
  //Title: Finding composition by volume of ethyl ether and nitrogen mixture

  model Ex5_1_a
    //parameter section
    parameter Real ba(unit = "cuft") = 1 "Basis of calculation";
    parameter Real T(unit="C")=20 "Temperature of mixture";
    parameter Real vpe(unit = "mmHg") = 442 "Vapor pressure of ethyl ether at 20 degree C";
    parameter Real P(unit = "mmHg") = 745 "Total pressure exerted by mixture";
    //variable section
    Real Ve(unit = "cuft") "volume occupied by ethyl ether";
    Real Vn(unit = "cuft") "volume occupied by nitrogen";
    Real pVe(unit = " ") "Percent composition of ethyl ether by volume";
    Real pVn(unit = " ") "Percent composition of nitrogen by volume";
    //equation section
  equation
    Ve = ba * vpe / P;
    Vn = ba - Ve;
    pVe = Ve / ba * 100;
    pVn = Vn / ba * 100;
  end Ex5_1_a;



  //Title: Finding composition by percent weight of mixture
  model Ex5_1_b
  /*Uses the volume composition from Ex5.1a*/
  extends Ex5_1_a;
  //parameter section
  parameter Real bas(unit="g-moles")=1 "basis of mixture";
  parameter Real ME(unit="g")=74 "Molar mass of ethyl ether";
  parameter Real MN(unit="g")=28 "Molar mass of N2";
  //variable section
  Real ne(unit="g-moles") "moles of ethyl ether in mixture according to basis";
  Real nn(unit="g-moles") "moles of N2 in mixture according to basis";
  Real we(unit="g") "mass of ethyl ether in mixture";
  Real wn(unit="g") "mass of N2 in mixture";
  Real pwe(unit=" ") "percent composition of ethyl ether";
  Real pwn(unit=" ") "percent composition of N2";
  //equation section
  equation
  /*The volume composition is same as molar composition for if we assume ethyl ether and N2 ideal gas*/
  ne=bas*(pVe/100);
  nn=bas*(pVn/100);
  we=ne*ME;
  wn=nn*MN;
  pwe=we/(we+wn)*100;
  pwn=wn/(we+wn)*100;
  end Ex5_1_b;


  //Title: Finding amount of vapor in pound per cuft mixture
  model Ex5_1_c
  /*Uses the value of molar composition and parameter from Ex5.1a,b*/
  extends Ex5_1_b;
  //parameter section
  parameter Real R(unit="(L*atm)/(K*mole)")=0.0821 "universal gas constant";
  parameter Real c1(unit=" ")=28.3168 "1cuft=28.3168L";
  parameter Real c2(unit=" ")=760 "1atm=760mmHg";
  parameter Real c3(unit=" ")=453.6 "1lb=453.6g";
  //variable section
  Real tn(unit="moles") "total moles in mixture";
  Real tne(unit="moles") "moles of ethyl ether";
  Real We(unit="lb") "mass of vapor";
  //equation section
  equation
  (P/c2)*(ba*c1)=tn*R*(T+273.15);
  tne=tn*(pVe/100);
  We=(tne*ME)/c3;
  end Ex5_1_c;





  //Title: Finding amount of vapor per pound N2
  model Ex5_1_d
  /*Uses the values of molar composition from Ex5.1b,c*/
  extends Ex5_1_c;
  //variable section
  Real tnn(unit="moles") "moles of N2";
  Real Wn(unit="lb") "mass of vapor-free gas";
  Real wen(unit=" ") "mass of vapor per pound vapor-free gas";
  //equation section
  equation
  tnn=tn*(pVn/100);
  Wn=(tnn*MN)/c3;
  wen=We/Wn;
  end Ex5_1_d;


  model Ex5_1_e
  /*Uses Ex5.1d,c for values of moles of ethyl ether and N2 */
  extends Ex5_1_d;
  //variable section
  Real nen(unit=" ") "number of moles of vapor per mole N2";
  //equation section
  equation
  nen=tne/tnn;
  end Ex5_1_e;















end Ex5_1;
