package Ex6_10
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.10; Page 156
  //Title: Calculating the composition and weight of crystals formed by cooling

  model Ex6_10_a
    //parameter section
    parameter Real ba(unit = "g") = 1000 "amount of solution taken as basis";
    parameter Real aNC1(unit = "g") = 21 "amount of Na2CO3 taken at 22.5 degree C";
    parameter Real aNS1(unit = "g") = 10 "amount of Na2SO4 taken at 22.5 degree C";
    parameter Real aW1(unit = "g") = 100 "amount of H2O taken at 22.5 degree C";
    parameter Real cNC2(unit = " ") = 13.8 "Composition of Na2CO3 taken at 17.5 degree C";
    parameter Real cNS2(unit = " ") = 8.5 "Composition of Na2SO4 taken at 17.5 degree C";
    parameter Real MNC(unit = "g") = 106 "Molar mass of Na2CO3";
    parameter Real MNS(unit = "g") = 142 "Molar mass of Na2SO4";
    parameter Real MW(unit = "g") = 18 "Molar mass of H2O";
    parameter Real mwNCc(unit=" ")=10 "moles of H2O in one mole Na2CO3.10H2O crystal";
    //variable section
    Real cNC1(unit = " ") "composition of Na2CO3 at 22.5 degree C ";
    Real cNS1(unit = " ") "composition of Na2SO4 at 22.5 degree C ";
    Real cW1(unit = " ") "composition of H2O at 22.5 degree C";
    Real aNCc(unit = "g") "amount of Na2CO3.10H2O crystallized";
    //equation section
  equation
    cNC1 = aNC1 / (aNC1 + aNS1 + aW1) * 100;
    cNS1 = aNS1 / (aNC1 + aNS1 + aW1) * 100;
    cW1 = aW1 / (aNC1 + aNS1 + aW1) * 100;
    cNC1 / 100 * ba = aNCc * (MNC / (MNC + MW*mwNCc)) + cNC2 / 100 * (ba - aNCc) "Only Na2CO3 formed crystal at 17.5 degree C; error more than 2% due to round-off errors in book";
  end Ex6_10_a;





  //Title: Calculating the composition and weight of crystals formed by cooling
  model Ex6_10_b
  //parameter section
    parameter Real ba(unit = "g") = 1000 "amount of solution taken as basis";
    parameter Real aNC1(unit = "g") = 21 "amount of Na2CO3 taken at 22.5 degree C";
    parameter Real aNS1(unit = "g") = 10 "amount of Na2SO4 taken at 22.5 degree C";
    parameter Real aW1(unit = "g") = 100 "amount of H2O taken at 22.5 degree C";
    parameter Real cNC2(unit = " ") = 10 "Composition of Na2CO3 taken at 10 degree C";
    parameter Real cNS2(unit = " ") = 6.2 "Composition of Na2SO4 taken at 10 degree C";
    parameter Real MNC(unit = "g") = 106 "Molar mass of Na2CO3";
    parameter Real MNS(unit = "g") = 142 "Molar mass of Na2SO4";
    parameter Real MW(unit = "g") = 18 "Molar mass of H2O";
    parameter Real mwNCc(unit=" ")=10 "moles of H2O in one mole Na2CO3.10H2O crystal";
    parameter Real mwNSc(unit=" ")=10 "moles of H2O in one mole Na2SO4.10H2O crystal";
    //variable section
    Real cNC1(unit = " ") "composition of Na2CO3 at 22.5 degree C ";
    Real cNS1(unit = " ") "composition of Na2SO4 at 22.5 degree C ";
    Real cW1(unit = " ") "composition of H2O at 22.5 degree C";
    Real aNCc(unit = " g") "amount of Na2CO3.10H2O crystallized";
    Real aNSc(unit = " g") "amount of Na2SO4.10H2O crystallized";
    //equation section
  equation
    cNC1 = aNC1 / (aNC1 + aNS1 + aW1) * 100;
    cNS1 = aNS1 / (aNC1 + aNS1 + aW1) * 100;
    cW1 = aW1 / (aNC1 + aNS1 + aW1) * 100;
    cNC1 / 100 * ba = aNCc * (MNC / (MNC + MW*mwNCc)) + cNC2 / 100 * (ba - aNCc-aNSc) "Na2CO3, Na2SO4 formed crystal at 10 degree C; error more than 2% due to round-off errors in book";
    cNS1 / 100 * ba = aNSc * (MNS / (MNS + MW*mwNSc)) + cNS2 / 100 * (ba - aNCc-aNSc) "Na2CO3, Na2SO4 formed crystal at 10 degree C; error more than 2% due to round-off errors in book";
  
  end Ex6_10_b;








end Ex6_10;
