package Ex6_12
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.12; Page 158
  //Title: Calculating the weight and composition of crystals formed when water is evaporated and solution is cooled

  model Ex6_12_a
    //parameter section
    parameter Real ba(unit = "lb") = 100 "amount of solution taken as basis";
    parameter Real cNC1(unit = " ") = 19.8 "Composition of Na2CO3 taken initially";
    parameter Real cNS1(unit = " ") = 5.9 "Composition of Na2SO4 taken initially";
    parameter Real MNC(unit = "g") = 106 "Molar mass of Na2CO3";
    parameter Real MNS(unit = "g") = 142 "Molar mass of Na2SO4";
    parameter Real MW(unit = "g") = 18 "Molar mass of H2O";
    parameter Real mwNCc(unit = " ") = 10 "moles of H2O in one mole Na2CO3.10H2O crystal";
    parameter Real mwNSc(unit = " ") = 10 "moles of H2O in one mole Na2SO4.10H2O crystal";
    parameter Real cNC2(unit = " ") = 15.3 "Composition of Na2CO3 at 20 degree C";
    parameter Real cNS2(unit = " ") = 9.4 "Composition of Na2SO4 at 20 degree C";
    parameter Real awe1(unit = "lb") = 10 "amount of water evaporated";
    //variable section
    Real aNCf(unit = "lb") "amount of Na2CO3 crystals formed";
    //equation section
  equation
    cNC1 / 100 * ba = cNC2 / 100 * (ba - awe1 - aNCf) + aNCf * MNC / (MNC + MW * mwNCc);
  end Ex6_12_a;

  model Ex6_12_b
  //parameter section
    parameter Real ba(unit = "lb") = 100 "amount of solution taken as basis";
    parameter Real cNC1(unit = " ") = 19.8 "Composition of Na2CO3 taken initially";
    parameter Real cNS1(unit = " ") = 5.9 "Composition of Na2SO4 taken initially";
    parameter Real MNC(unit = "g") = 106 "Molar mass of Na2CO3";
    parameter Real MNS(unit = "g") = 142 "Molar mass of Na2SO4";
    parameter Real MW(unit = "g") = 18 "Molar mass of H2O";
    parameter Real mwNCc(unit = " ") = 10 "moles of H2O in one mole Na2CO3.10H2O crystal";
    parameter Real mwNSc(unit = " ") = 10 "moles of H2O in one mole Na2SO4.10H2O crystal";
    parameter Real cNC2(unit = " ") = 14.8 "Composition of Na2CO3 corresponding to concentration after evaporation at 20 degree C";
    parameter Real cNS2(unit = " ") = 11.4 "Composition of Na2SO4 corresponding to concentration after evaporation at 20 degree C";
    parameter Real awe1(unit = "lb") = 20 "amount of water evaporated";
    //variable section
    Real aNCf(unit = "lb") "amount of Na2CO3 crystals formed";
    Real aNSf(unit = "lb") "amount of Na2SO4 crystals formed";
    //equation section
  equation
    cNC1 / 100 * ba = cNC2 / 100 * (ba - awe1 - aNCf-aNSf) + aNCf * MNC / (MNC + MW * mwNCc);
    cNS1 / 100 * ba = cNS2 / 100 * (ba - awe1 - aNCf-aNSf) + aNSf * MNS / (MNS + MW * mwNSc);
  end Ex6_12_b;








end Ex6_12;
