 //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.17; Page 181
  //Title: Calculating volume of oxygen dissolved in water
model Ex6_17
//parameter section
parameter Real ba(unit="lb")=10 "amount of water as basis";
parameter Real T(unit="C")=20 "Temperature of water";
parameter Real P(unit="atm")=1 "Pressure exerted by oxygen";
parameter Real Hi(unit="atm")=25*10^(-6) "inverse of Henry's constant";
parameter Real MW(unit="g")=18 "Molar mass of H2O";
//variable section
Real mfO(unit=" ") "mole fraction of O2 in H2O";
Real aOw(unit="lb-moles") "amount of O2 dissolved in H2O";
Real vOw(unit="cuft") "volume of O2 dissolved in H2O";
//equation section
equation
mfO=Hi*P;
aOw=ba/MW*mfO;
vOw=aOw*359*(T+273.15)/273.15 "359 is standard pressure in cuft; 273.15 is standard temperature";
end Ex6_17;
