//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.4; Page 147
  //Title: Finding Temperature at which 40% NaHCO3 will cystallize
model Ex6_4
//parameter section
parameter Real ba(unit="lb")=1000 "amount of H2O as basis";
parameter Real sN1(unit="lb-moles")=1.96 "amount of NaHCO3 soluble in 1000 lb H2O at 60 degree C";
parameter Real ps(unit=" ")=40 "percent of NaHCO3 to be crystallized";
//variable section
Real fNr(unit="lb-moles") "amount of NaHCO3 remaining in solution";
//equation section
equation 
fNr=(sN1/1000)*ba*(1-ps/100) "From solubility data, solution having solubility of 1.176lb-moles per 1000lb H2O has approx temperature 23 degree C";
end Ex6_4;
