//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.7; Page 149
  //Title: Calculating the temperature to which solution to be cooled to crystallize 60% Na2SO4.10H2O
model Ex6_7
//parameter section
parameter Real ba(unit="lb")=1000 "amount of initial solution taken as basis";
parameter Real sN1(unit=" ")=32.5 "percentage solubility of Na2SO4 at 32.5 degree C in water";
parameter Real Nc(unit=" ")=60 "percent of Na2SO4 to be crystallized";
parameter Real wn(unit="lb-mole")=10 "lb-moles of water per lb-mole Na2SO4 in Na2SO4 crystal";
parameter Real MN(unit="g")=142 "Molar mass of Na2SO4";
parameter Real MW(unit="g")=18 "Molar mass of water";
//variable section
Real aNsi(unit="lb") "amount of Na2SO4 in solution initially";
Real aWsi(unit="lb") "amount of water in soultion initialy";
Real aNc(unit="lb") "amount of Na2SO4 crystallized";
Real aNs(unit="lb") "amount of Na2SO4 in solution finally";
Real aWc(unit="lb") "amount of water removed from solution as crystal";
Real aWs(unit="lb") "amount of water in solution";
Real cfs(unit=" ") "composition of final solution";
//equation section
equation
aNsi=ba*(sN1/100);
aWsi=ba-aNsi;
aNc=aNsi*(Nc/100);
aNs=aNsi-aNc;
aWc=(aNc/MN)*wn*MW;
aWs=aWsi-aWc;
cfs=aNs/(aWs+aNs)*100 "23.3% composition solution corresponds to 27 degree C";
end Ex6_7;
