//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-7:Material Balances
//Example 7.4; Page 203
package Ex7_4
        //Title: Calculating the degree of completion of 2 simultaneous reactions

  model Ex7_4_a
    //parameter section
    parameter Real ba(unit = "lb") = 1000 "amount of salt charged(NaCl) as basis";
    parameter Real aHs(unit = " ") = 75 "amount of H2SO4 by mass in aqueous sulphuric acid";
    parameter Real NSsc(unit = " ") = 91.48 "composition of Na2SO4 in salt cake";
    parameter Real NHsc(unit = " ") = 4.79 "composition of NaHSO4 in salt cake";
    parameter Real NCsc(unit = " ") = 1.98 "composition of NaCl in salt cake";
    parameter Real Wsc(unit = " ") = 1.35 "composition of H2O in salt cake";
    parameter Real HCsc(unit = " ") = 0.4 "composition of HCl in salt cake";
    parameter Real MN(unit = "g") = 23 "Molar mass of Na";
    parameter Real MO(unit = "g") = 16 "Atomic mass of 1 mole O";
    parameter Real MH(unit = "g") = 1 "Atomic mass of 1 mole H";
    parameter Real MS(unit = "g") = 32 "Atomic mass of 1 mole S";
    parameter Real MCl(unit = "g") = 35.5 "Molar mass of Cl";
    //variable section
    Real mNC(unit = "lb-mole") "moles of NaCl used";
    Real msc(unit = "lb") "mass of salt cake formed";
    Real maa(unit = "lb") "mass of acid added";
    Real mHd(unit = "lb") "mass of HCl gas driven off";
    Real mWd(unit = "lb") "mass of H2O gas driven off";
    Real pWlg(unit = " ") "percent of H2O in gas leaving";
    Real pHlg(unit = " ") "percent of HCl in gas leaving";
    Real deg2(unit = " ") "degree of completion of second reaction";
    Real mNSf(unit = " ") "moles of Na2SO4 formed";
    Real mNCr(unit = " ") "moles of NaCl remaining";
    //equation section
  equation
    mNC = ba / (MN + MCl);
    ba * (MN / (MN + MCl)) = msc * (NSsc / 100 * (2 * MN / (2 * MN + MS + 4 * MO)) + NHsc / 100 * (MN / (MN + MH + MS + 4 * MO)) + NCsc / 100 * (MN / (MN + MCl))) "Sodium Balance";
    ba * (MCl / (MN + MCl)) = msc * (NCsc / 100 * (MCl / (MN + MCl)) + HCsc / 100 * (MCl / (MH + MCl))) + mHd * (MCl / (MH + MCl)) "Chlorine balance";
    maa * aHs / 100 * (MS / (MS + 2 * MH + 4 * MO)) = msc * (NSsc / 100 * (MS / (2 * MN + MS + 4 * MO)) + NHsc / 100 * (MS / (MN + MH + MS + 4 * MO))) "Sulphur balance";
    maa * (aHs / 100 * (2 * MH / (MS + 2 * MH + 4 * MO)) + (1 - aHs / 100) * (2 * MH / (2 * MH + MO))) = mHd * (MH / (MH + MCl)) + mWd * (2 * MH / (2 * MH + MO)) + msc * (NHsc / 100 * (MH / (MN + MH + MS + 4 * MO)) + Wsc / 100 * (2 * MH / (2 * MH + MO)) + HCsc / 100 * (MH / (MH + MCl))) "Hydrogen balance";
    pWlg = mWd / (mWd + mHd) * 100;
    pHlg = mHd / (mWd + mHd) * 100;
/*Degree of Completion of first reaction is 100% as no traces of H2SO4 is found in any product*/
    mNSf = msc * NSsc / 100 / (2 * MN + MS + 4 * MO);
    mNCr = msc * NCsc / 100 / (MN + MCl);
    deg2 = mNSf / (mNSf + mNCr) * 100 "1mole of NaCl forms 1 mole of Na2SO4";
  end Ex7_4_a;

  model Ex7_4_b
  /*This model takes values from Ex7.4a that were used to find values in part a*/
  extends Ex7_4_a;
  //variable section
  Real msc(unit = "lb") "mass of salt cake formed";
    Real maa(unit = "lb") "mass of acid added";
    Real mHd(unit = "lb") "mass of HCl gas driven off";
    Real mWd(unit = "lb") "mass of H2O gas driven off";
    Real pWlg(unit = " ") "percent of H2O in gas leaving";
    Real pHlg(unit = " ") "percent of HCl in gas leaving";
    Real mg(unit="lb") "total mass of gases";
    //equation section
    equation
    mg=mHd+mWd;
  end Ex7_4_b;




end Ex7_4;
