package Ex7_7
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-7:Material Balances
  //Example 7.7; Page 214
  //Title: finding the amount of carbon formed on catalyst

  model Ex7_7_a
    //parameter section
    parameter Real ba(unit = "lb-mole") = 1 "amount of gas leaving reactor as basis";
    parameter Real pPi(unit = "") = 44.5 "percent propane leaving reactor";
    parameter Real pPli(unit = "") = 21.3 "percent propylene leaving reactor";
    parameter Real pHi(unit = "") = 25.4 "percent hydrogen leaving reactor";
    parameter Real pEli(unit = "") = 0.3 "percent Ethylene leaving reactor";
    parameter Real pEi(unit = "") = 5.3 "percent Ethane leaving reactor";
    parameter Real pMi(unit = "") = 3.2 "percent Methane leaving reactor";
    parameter Real MP(unit = "g") = 44.09 "Molar mass of propane";
    parameter Real MPl(unit = "g") = 42.08 "Molar mass of propylene";
    parameter Real MEl(unit = "g") = 28.05 "Molar mass of ethylene";
    parameter Real ME(unit = "g") = 30.07 "Molar mass of ethane";
    parameter Real MM(unit = "g") = 16.04 "Molar mass of methane";
    parameter Real MH2(unit = "g") = 2.016 "Molar mass of hydrogen";
    parameter Real MC(unit = "g") = 12 "molar mass of carbon";
    parameter Real MH(unit = "g") = 1 "mass of 1 mole H atoms";
    parameter Real app(unit = "lb") = 100000 "amount of propylene in product";
    parameter Real pPr(unit = " ") = 98 "percent of propane in recycle by weight";
    parameter Real pPlr(unit = " ") = 2 "percent of propylene in recycle by weight";
    parameter Real pPpp(unit = " ") = 0.5 "percent propane in propylene product ";
    parameter Real pPlpp(unit = " ") = 98.8 "percent propylene in propylene product ";
    parameter Real pEpp(unit = " ") = 0.7 "percent ethane in propylene product ";
    parameter Real pPlg(unit = " ") = 1.1 "percent of propane in light gas";
    parameter Real pPllg(unit = " ") = 0.7 "percent of propylene in light gas";
    //variable section
    Real aPi(unit = "lb-moles") "amount of Propane in mixture leaving reactor";
    Real aPli(unit = "lb-moles") "amount of Propylene in mixture leaving reactor";
    Real aHi(unit = "lb-moles") "amount of hydrogen in mixture leaving reactor";
    Real aEli(unit = "lb-moles") "amount of Ethylene in mixture leaving reactor";
    Real aEi(unit = "lb-moles") "amount of ethane in mixture leaving reactor";
    Real aMi(unit = "lb-moles") "amount of methane in mixture leaving reactor";
    Real mPi(unit = "lb") "amount of Propane in mixture leaving reactor";
    Real mPli(unit = "lb") "amount of Propylene in mixture leaving reactor";
    Real mHi(unit = "lb") "amount of hydrogen in mixture leaving reactor";
    Real mEli(unit = "lb") "amount of Ethylene in mixture leaving reactor";
    Real mEi(unit = "lb") "amount of ethane in mixture leaving reactor";
    Real mMi(unit = "lb") "amount of methane in mixture leaving reactor";
    Real agf(unit = "lb") "amount of gas formed from 1 mole propane";
    Real pr(unit = "lb-moles/hr") "production rate of propylene in lb-moles per hr";
    Real tr(unit = "lb-moles") "total amount of recycle";
    Real tff(unit = "lb-moles") "total amount of fresh feed";
    Real tlg(unit = "lb-moles") "total amount of light gases";
    Real pPrm(unit = "  ") "percent of propane in recycle by lb-moles";
    Real pPlrm(unit = "  ") "percent of propylene in recycle by lb-moles";
    Real aPf(unit = "lb-moles") "amount of propane in combined feed";
    Real aPlf(unit = "lb-moles") "amount of propylene in combined feed";
    Real gfp(unit = "lb-moles") "gases formed from the propane entering";
    Real tglr(unit = "lb-mole") "total gas leaving reactor";
    Real plr(unit = "lb-moles") "amount of propane leaving reactor";
    Real Pllr(unit = "lb-moles") "amount of propylene leaving reactor";
    Real CPe(unit = "lb") "amount of Carbon in propane entering feed";
    Real aClg(unit = "lb-moles") "amount of Carbon atoms in 1lb-mole light gas";
    Real Clg(unit = "lb") "amount of carbon in gases leaving reactor";
    Real aCd(unit = "lb") "amount of carbon deposited on catalyst";
    Real pCd(unit=" ") "percent of carbon deposit";
    //equation section
  equation
    aPi = ba * pPi / 100;
    aPli = ba * pPli / 100;
    aEli = ba * pEli / 100;
    aHi = ba * pHi / 100;
    aEi = ba * pEi / 100;
    aMi = ba * pMi / 100;
    mPi = MP * aPi;
    mPli = MPl * aPli;
    mEi = ME * aEi;
    mEli = MEl * aEli;
    mMi = MM * aMi;
    mHi = MH2 * aHi;
    agf = 8 / (8 * pPi / 100 + 6 * pPli / 100 + 2 * pHi / 100 + 4 * pEli / 100 + 6 * pEi / 100 + 4 * pMi / 100);
    pr = app / (24 * MPl);
    pPrm = pPr / MP / (pPr / MP + pPlr / MPl);
    pPlrm = pPlr / MPl / (pPlr / MPl + pPr / MP);
    aPf = tff + tr * pPrm;
    aPlf = tr * pPlrm;
    gfp = aPf * agf;
    tglr = gfp + aPlf "propylene passes reactor unreacted";
    plr = gfp * pPi / 100;
    Pllr = pPli / 100 * gfp + aPlf;
    plr = pPrm * tr + pr * (pPpp / MP) / (pPpp / MP + pPlpp / MPl + pEpp / ME) / 0.9885 + pPlg / 100 * tlg "Propane material balance of gases after passing through absorber";
    Pllr = aPlf + pr + pPllg / 100 * tlg "Propylene material balance of gases after passing through absorber";
    tglr = tr + pr / 0.9855 + tlg "Total material balance of gases after passing through absorber";
    CPe = aPf * 3 * MC "3 atoms af carbon in every molecule propane";
    aClg = (3 * pPi + 3 * pPli + 2 * pEi + 2 * pEli + pMi) / 100;
    Clg = MC * aClg * agf * aPf;
    aCd = CPe - Clg;
    pCd=aCd/(MP*aPf)*100;
  end Ex7_7_a;



  model Ex7_7_b
  extends Ex7_7_a;
  /*Uses the values obtained by calculation from Ex7.7a*/
  //parameter section
  parameter Real rf(unit="lb-moles/cuft")=4.1 "Rate of passing total feed over catalyst";
  parameter Real dc(unit="lb/cuft")=54 "density of catalyst";
  parameter Real ct(unit=" ")=2 "percent carbon tolerance";
  //variable section
  Real tfe(unit="lb-moles") "total feed entering reactor";
  Real vC(unit="cuft") "volume of catalyst";
  Real wC(unit="lb") "weight of catalyst";
  Real ctm(unit="lb") "maximum amount of carbon thata can be deposited";
  Real pp(unit="min") "process period";
  //equation section
  equation
  tfe=tr+tff;
  vC=tfe/rf;
  wC=dc*vC;
  ctm=ct/100*wC;
  pp=ctm/aCd*60 "amount of carbon deposited in 1hr is calculated in previous part as amount of carbon deposited";
  end Ex7_7_b;

  model Ex7_7_c
  extends Ex7_7_a;
  /*Uses the values obtained by calculation from Ex7.7a*/
  //variable section
  Real Hl(unit="lb") "amount of Hydrogen leaving reactor";
  Real Pl(unit="lb") "amount of propane leaving reactor";
  Real Pll(unit="lb") "amount of propylene leaving reactor";
  Real El(unit="lb") "amount of ethane leaving reactor";
  Real Ell(unit="lb") "amount of ethylene leaving reactor";
  Real Ml(unit="lb") "amount of methane leaving reactor";
  Real Ep(unit="lb") "amount of ethane in product";
  Real Elg(unit="lb") "amount of ethane in light gas";
  Real tmlg(unit="lb") "total mass of light gas";
  Real tp(unit="lb") "total mass of product";
  Real to(unit="lb") "total output";
  Real ti(unit="lb") "total input";
  //equation section
  equation
  Hl=pHi/100*gfp*MH2 "This amount of hydrogen also leaves as light gas";
  Pl=pPi/100*gfp*MP;
  Pll=pPli/100*gfp*MPl;
  El=pEi/100*gfp*ME;
  Ell=pEli/100*gfp*MEl "This amount of ethylene also leaves as light gas";
  Ml=pMi/100*gfp*MM "This amount of methane also leaves as light gas";
  Ep=tp*pEpp/100;
  Elg=El-Ep;
  tmlg=Hl+Ell+Ml+Elg+pPlg*tlg*MP/100+pPllg/100*tlg*MPl;
  tp=pr*MPl/(pPlpp/100);
  to=tmlg+tp+aCd;
  ti=tff*MP;
  end Ex7_7_c;


  model Ex7_7_d
  extends Ex7_7_c;
  /*Uses the values found out in part c*/
  //varaible section
  Real MBi(unit="lb") "Once through material balance-input";
  Real MBo(unit="lb") "Once through material balance-output";
  //equation section
  equation
  MBi=ti+tr*pPrm*MP/(pPr/100);
  MBo=to+tr*pPrm*MP/(pPr/100);
  end Ex7_7_d;

  model Ex7_7_e
  extends Ex7_7_c;
  /*Uses values found out in part c*/
  //variable section
  Real pfc(unit="lb-moles") "amount of propylene formed in convertor";
  Real per(unit="lb-moles") "amount of propane consumed in convertor";
  Real py(unit=" ") "ultimate yield of propylene";
  //equation section
  equation
  pfc=pr+pPllg/100*tlg;
  per=tff-(Pl/MP)+pPrm*tr;
  py=pfc/per*100;
  end Ex7_7_e;

  model Ex7_7_f
  extends Ex7_7_e;
  /*Uses values found out in part e*/
  //variable section
  Real y(unit=" ") "yield percent per pass";
  //equation section
  equation
  y=pfc/aPf*100;
  end Ex7_7_f;


  model Ex7_7_g
  extends Ex7_7_e;
  /*Uses values found out in part e*/
  //variable section
  Real RR(unit=" ") "recycle ratio";
  //equation section
  equation
  RR=pPrm*tr/tff;
  end Ex7_7_g;


  model Ex7_7_h
  extends Ex7_7_e;
  /*Uses values found out in part e*/
  //variable section
  Real crr(unit=" ") "combined recycle ratio";
  //equation section
  equation
  crr=(pPrm*tr+tff)/tff;
  end Ex7_7_h;











































end Ex7_7;
