//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-8: Thermophysics
  //Example 8.3; Page 278
  //Title: Estimating heat of vaporization of Freon-12
model Ex8_3
parameter Real T(unit="F")=200 "Temperatur eof Freon-12";
parameter Real sr(unit=" ")=0.516 "sr*Tc/Tc'=0.516 for freon where reference substance is water";
parameter Real Tc(unit="F")=232.5 "Critical temperature of Freon-12";
parameter Real Hvw(unit="Btu/lb-mole")=7707 "Heat of vaporization of water at Tr=0.951";
//variable section
Real Tr(unit=" ") "Reduced temperature of Freon-12";
Real Hvf(unit="Btu/lb-mole") "Heat of vaporization of freon-12";
//equation section
equation
Tr=((T-32)*5/9+273.15)/((Tc-32)*5/9+273.15);
Hvf=sr*Hvw;
end Ex8_3;
