//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-8: Thermophysics
  //Example 8.5; Page 281
  //Title: Calculating the enthalpy of 1lb steam at 350 degree F and pressure 50 psi
model Ex8_5
//parameter section
parameter Real P(unit="psi")=50 "pressure of steam";
parameter Real T(unit="F")=350 "Temperature of steam";
parameter Real Ts(unit="F")=281 "saturation temperature of steam at 50psi pressure";
parameter Real SHw(unit="Btu/(lb*F)")=1.006 "mean specific heat of water";
parameter Real SHs(unit="Btu/(lb-mole*F)")=9.2 "mean specific heat of steam";
parameter Real Hv(unit="Btu/lb")=924 "Heat of vaporization of water";
parameter Real MW(unit="g")=18 "Molar mass of water";
//variable section
Real Ew(unit="Btu/lb") "Enthalpy of liquid water at 281 degree F";
Real Sv(unit="Btu/lb") "Super heat of steam at 350 degree F";
Real E(unit="Btu/lb") "Enthalpy of steam at 350 degree F";
//equation section
equation
Ew=(Ts-32)*SHw;
Sv=(T-Ts)*SHs/MW;
E=Ew+Hv+Sv;
end Ex8_5;
