//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-8: Thermophysics
  //Example 8.6; Page 282
  //Title: Calculating enthalpy of zinc vapor at 1000 degree C
model Ex8_6
//parameter section
parameter Real T0(unit="C")=0 "reference temperature of zinc solid";
parameter Real Tm(unit="C")=419 "Melting temperature of zinc";
parameter Real Tb(unit="C")=907 "Boiling Temperature of zinc";
parameter Real Tf(unit="C")=1000 "final temperature of zinc";
parameter Real SHs(unit="cal/(g*K)")=0.105 "mean Specific heat of solid zinc from 0 degree C to 419 degree C";
parameter Real SHl(unit="cal/(g*K)")=0.109 "mean Specific heat of liquid zinc from 419 degree C to 907 degree C";
parameter Real Hf(unit="cal/g-atom")=1660 "Heat of fusion of zinc";
parameter Real SHv(unit="cal/(g-mole*K)")=4.97 "mean Specific heat of vapor zinc from 907 degree C to 1000 degree C";
parameter Real MZ(unit="g")=65.4 "molar mass of zinc";
//variable section
Real Hv(unit="cal/g-mole") "Heat of vaporization of zinc";
Real E(unit="cal/g") "Total enthalpy of zinc at 1000 degree C";
//equation section
equation
Hv/(Tb+273.15)=8.75+4.571*log10(Tb+273.15);
E=SHs*(Tm-T0)+Hf/MZ + SHl*(Tb-Tm)+Hv/MZ+SHv/MZ*(Tf-Tb);
end Ex8_6;
