//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.15; Page 341
  //Title: Calculating the standard heat of reaction of a process
model Ex9_15
//parameter section
parameter Real aMO(unit="kg")=10 "amount of Manganese oxide(Mn3O4) heated";
parameter Real aC(unit="kg")=3 "amount of amorphous carbon (coke) heated with Mn3O4";
parameter Real aM(unit="kg")=4.8 "amount of manganese metal in product";
parameter Real aMnO(unit="kg")=2.6 "amount of MnO in product as slag";
parameter Real MMO(unit="g")=229 "molar mass of Mn3O4";
parameter Real MC(unit="g")=12 "molar mass of Carbon";
parameter Real MM(unit="g")=55 "molar mass of Mn";
parameter Real MMnO(unit="g")=71 "molar mass of MnO";
parameter Real HMO(unit="cal/g-mole")=-331400 "Heat of formation of Mn3O4 per g-mole";
parameter Real HC(unit="cal/g-mole")=2600 "Heat of formation of C per g-mole";
parameter Real HM(unit="cal/g-mole")=0 "Heat of formation of Mn per g-mole";
parameter Real HMnO(unit="cal/g-mole")=-92000 "Heat of formation of MnO per g-mole";
parameter Real HCO(unit="cal/g-mole")=-26416 "Heat of formation of CO per g-mole";
//variable section
Real mMO(unit="kg-mole") "amount of Manganese oxide(Mn3O4) in kg-mole";
Real mC(unit="kg-mole") "amount of amorphous carbon in kg-mole";
Real mM(unit="kg-mole") "amount of Manganese in kg-mole";
Real mMnO(unit="kg-mole") "amount of Manganese oxide(MnO) in kg-mole";
Real muMO(unit="kg-mole") "amount of unconverted Mn3O4";
Real mCO(unit="kg-mole") "amount of CO formed";
Real muC(unit="kg-mole") "amount of unconverted C";
Real Hfar(unit="kcal") "Heat of formation of active reactants";
Real Hfp(unit="kcal") "Heat of formation of products";
Real SH(unit="kcal") "Standard heat of reaction";
//equation section
equation
mMO=aMO/MMO;
mC=aC/MC;
mM=aM/MM;
mMnO=aMnO/MMnO;
muMO=mMO-(mM+mMnO)/3;
mCO=4*(mMO-muMO)-mMnO;
muC=mC-mCO;
Hfar=HMO*(mMO-muMO)+HC*(mC-muC);
Hfp=HM*mM+HMnO*mMnO+HCO*mCO;
SH=Hfp-Hfar /*Answer given in book is wrong as they have numerically added heat of formation of Mn3O4 and Coke. However they will get subtracted numerically as per the given data*/;
end Ex9_15;
