//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.21; Page 355
  //Title: Calculating the effect on theoretical flame temperature by changing temperature of gas entering
model Ex9_21
//parameter section
parameter Real HcCO(unit="cal/(g-mole*K)")=7.587 "Heat capacity of CO";
parameter Real HcO2(unit="cal/(g-mole*K)")=7.941 "Heat capacity of O2";
parameter Real HcN2(unit="cal/(g-mole*K)")=7.507 "Heat capacity of N2";
parameter Real Ti(unit="C")=1000 "initial temperature of entering gases";
parameter Real pCg(unit=" ")=20 "percent CO in gas";
parameter Real pNg(unit=" ")=80 "percent N2 in gas";
parameter Real peO(unit=" ")=100 "percent excess oxygen";
parameter Real ba(unit="g-mole")=1 "amount of CO as basis";
parameter Real pOA(unit=" ")=0.21 "fraction of O2 in air";
parameter Real HC(unit="cal")=-67636 "Heat of combustion at 298K";
//variable section
Real Hr(unit="cal") "Total enthalpy of reactants";
Real aNg(unit="g-mole") "amount of N2 in original gas";
Real aOs(unit="g-mole") "amount of O2 supplied";
Real aOr(unit="g-mole") "amount of O2 required";
Real aAs(unit="g-mole") "amount of air supplied";
Real tNp(unit="g-mole") "total amount of N2 present";
Real aCO2f(unit="g-mole") "amount of CO2 formed";
Real aO2r(unit="g-mole") "amount of O2 remaining";
Real T(unit="K") "final temperature of gas mixture";
Real EO(unit="cal") "Enthalpy of O2 product";
Real ECO2(unit="cal") "Enthalpy of CO2 product";
Real EN2(unit="cal") "Enthalpy of N2 product";
Real Ep(unit="cal") "Enthalpy of products";
//equation section
equation
aNg=ba*pNg/pCg;
aOr=ba*0.5;
aOs=aOr*(1+peO/100);
aAs=aOs/pOA;
tNp=(aAs-aOs)+aNg;
aCO2f=ba;
aO2r=aOs-aOr;
Hr=HcCO*ba*(Ti-25)+HcO2*aOs*(Ti-25)+HcN2*tNp*(Ti-25);
EO=aO2r*(6.117*(T-298)+0.003167/2*(T^2-298^2)-1.005/3*10^(-6)*(T^3-298^3));
ECO2=aCO2f*(6.339*(T-298)+0.01014/2*(T^2-298^2)-3.415/3*10^(-6)*(T^3-298^3));
EN2=tNp*(6.457*(T-298)+0.001389/2*(T^2-298^2)-0.069/3*10^(-6)*(T^3-298^3));
Ep=EO+ECO2+EN2;
Ep=Hr-HC;
end Ex9_21;
