//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.7 Page number 19
//Title: Conversion of unit of thermal conductivity(k) from Btu/((hr)(ft)(F)) to g-cal/((sec)(cm)(C))
model Ex1_7
//parameter section
parameter Real ki(unit="Btu/((hr)(ft)(F))")=16.2 "Thermal conductivity in Btu/((hr)(ft)(F))";
parameter Real c1(unit=" ")=252 "Conversion factor of Btu to g-cal; 1Btu=252g-cal";
parameter Real c2(unit=" ")=3600 "Conversion factor of hr to sec; 1hr=3600sec";
parameter Real c3(unit=" ")=12*2.54 "Conversion factor of ft to cm; 1ft=12*2.54cm";
parameter Real c4(unit=" ")=5/9 "Conversion factor of F to C";
//variable section
Real kf(unit="g-cal/((sec)(cm)(C))") "Thermal conductivity in g-cal/((sec)(cm)(C))";
//equation
equation
kf=ki*c1/(c2*c3*c4) "Conversion formula of thermal conductivity(k) from Btu/((hr)(ft)(F)) to g-cal/((sec)(cm)(C))";
end Ex1_7;
