//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-11:Fuels and Combustion
  //Example 11.4; Page 417
  //Title: Applying material and energy balance for entire plant
model Ex11_4
//parameter section
parameter Real ba(unit="lb")=100 "amount of coal fired as basis";
parameter Real pCcf(unit=" ")=65.93 "percent of carbon in coal fired";
parameter Real pHcf(unit=" ")=3.5 "percent of available hydrogen in coal fired";
parameter Real pNcf(unit=" ")=1.3 "percent of nitrogen in coal fired";
parameter Real pWcf(unit=" ")=6.31 "percent of combined water in coal fired";
parameter Real pMcf(unit=" ")=4.38 "percent of free moisture in coal fired";
parameter Real pAcf(unit=" ")=18.58 "percent of ash in coal fired";
parameter Real Tc(unit="F")=65 "Average temperature of coal ";
parameter Real thv(unit="Btu/lb")=11670 "Total heating value";
parameter Real tw(unit="lb")=119000 "Total weight of coal fired";
parameter Real pAap(unit=" ")=87.4 "percent of ash in ash pit";
parameter Real pCap(unit=" ")=12.6 "percent of carbon in ash pit";
parameter Real sha(unit=" ")=0.23 "mean specific heat from73 to 255 degree farheneit";
parameter Real Tap(unit="F")=255 "Average temperature in ash pit";
parameter Real pCO2fg(unit=" ")=11.66 "percent of CO2 in flue gas";
parameter Real pO2fg(unit=" ")=6.52 "percent of O2 in flue gas";
parameter Real pCOfg(unit=" ")=0.04 "percent of CO in flue gas";
parameter Real pN2fg(unit=" ")=81.78 "percent of N2 in flue gas";
parameter Real Tfg(unit="F")=488 "Averae temperature of flue gas";
parameter Real dbTa(unit="F")=73 "Dry bulb temp of air";
parameter Real wbTa(unit="F")=59.4 "wet bulb temp of air";
parameter Real mha(unit=" ")=0.012 "molal humidity of air";
parameter Real Pa(unit="in.Hg")=29.08 "Averag ebarometric pressure of air";
parameter Real fwTs(unit="F")=193 "feed water temp in steam generated";
parameter Real wwe(unit="lb")=1038400 "weight of water evaporated";
parameter Real qs(unit=" ")=98.3 "Quality of steam";
parameter Real MC(unit="g")=12 "Molar mass of Carbon";
parameter Real MCO2(unit="g")=44 "Molar mass of Carbon dioxide";
parameter Real MCO(unit="g")=28 "Molar mass of Carbon monooxide";
parameter Real MO(unit="g")=16 "Molar mass of O atoms";
parameter Real MN2(unit="g")=28 "Molar mass of N2";
parameter Real MA(unit="g")=29 "Molar mass of air";
parameter Real MW(unit="g")=18 "Molar mass of water";
parameter Real MH2(unit="g")=2.016 "molar mass of H2";
parameter Real hv(unit="Btu/lb-mole")=18964 "Heat of vaporization of water at 73 degree F";
parameter Real hvR(unit="Btu/lb")=14490 "Heating value of refuse per lb carbon";
parameter Real hvsg(unit="cal/g-mole")=67636 "Heating value of stack gases per lb-mole CO";
parameter Real c1(unit=" ")=1.8 "1cal/g-mole=1.8Btu/lb-mole";
parameter Real hcCO2(unit="Btu/(lb-mole*R)")=9.92 "Mean heat capacity of CO2 between 73 and 488 degree F";
parameter Real hcCO(unit="Btu/(lb-mole*R)")=7.05 "Mean heat capacity of CO between 73 and 488 degree F";
parameter Real hcO2(unit="Btu/(lb-mole*R)")=7.24 "Mean heat capacity of O2 between 73 and 488 degree F";
parameter Real hcN2(unit="Btu/(lb-mole*R)")=7.02 "Mean heat capacity of N2 between 73 and 488 degree F";
parameter Real hcW(unit="Btu/(lb-mole*R)")=8.2 "Mean heat capacity of H2O between 73 and 488 degree F";

//variable section
Real ac(unit="lb") "Ash content of coal";
Real wr(unit="lb") "weight of refuse formed";
Real CC(unit="lb") "Carbon in coal";
Real Cr(unit="lb") "Carbon in refuse";
Real Csg(unit="lb") "Carbon in entering stack gases";
Real asg(unit="lb-moles") "amount of stack gases";
Real CO2sg(unit="lb") "amount of CO2 in stack gas";
Real COsg(unit="lb") "amount of CO in stack gas";
Real O2sg(unit="lb") "amount of O2 in stack gas";
Real N2sg(unit="lb") "amount of N2 in stack gas";
Real tsg(unit="lb") "total mass of stack gas";
Real MWsg(unit="g") "Molar mass of stack gas"; 
Real Nc(unit="lb") "amount N2 in coal";
Real Na(unit="lb") "amount of N2 from air";
Real ada(unit="lb") "amount of dry air supplied";
Real wsa(unit="lb") "amount of water supplied with air";
Real tmwa(unit="lb-moles") "total moles of wet air";
Real Vwa(unit="cu ft") "Volume of wet air introduced";
Real taH2(unit="lb-moles") "total amount of H2 molecules";
Real ppWsg(unit="in.Hg") "Partial pressure of water in stack gases";
Real mwg(unit="lb-moles") "Amount of wet gas";
Real Vgp(unit="cuft") "Volume of gaseous products at 488 degree F and 29.08 in.Hg";
Real rCb(unit="lb") "Input amount of C - output";
Real rNb(unit="lb") "Input amount of N - output";
Real rHb(unit="lb") "Input amount of H - output";
Real rOb(unit="lb") "Input amount of O - output";
Real rAb(unit="lb") "Input amount of Ash - output";
Real Orc(unit="lb-moles") "Amount of O2 required for combustion";
Real Arc(unit="lb-moles") "Amount of Air required for combustion";
Real Ae(unit="lb-moles") "Amount of excess air";
Real hvC(unit="Btu") "heating value of coal";
Real Ewv(unit="Btu") "enthalpy of water vapour accompanying dry air";
Real thi(unit="Btu") "total heat input";
Real hvr(unit="Btu") "heat value in refuse";
Real hvSG(unit="Btu") "heat value of stack gases";
Real Er(unit="Btu") "enthalpy of refuse";
Real Edsg(unit="Btu") "enthalpy of dry stack gases";
Real Ewsg(unit="Btu") "Enthalpy of water vapor in stack gases";
Real Hgs(unit="Btu") "Heat utilized in generating steam";
Real tho(unit="Btu") "total heat output";
Real ul(unit="Btu") "undetermined heat losses";
//equation sction
equation
ac=ba*pAcf/100;
wr=ac/(pAap/100);
CC=pCcf/100*ba;
Cr=wr*pCap/100;
Csg=CC-Cr;
asg=Csg/((pCOfg/100+pCO2fg/100)*MC);
CO2sg=asg*pCO2fg/100*MCO2;
COsg=asg*pCOfg/100*MCO;
O2sg=asg*pO2fg/100*MO*2;
N2sg=asg*pN2fg/100*MN2;
tsg=CO2sg+COsg+O2sg+N2sg;
MWsg=tsg/asg;
Nc=ba*pNcf/100;
Na=N2sg-Nc;
ada=Na/MN2*MA/0.79 "N2 is 79% of air";
wsa=ada/MA*mha*MW;
tmwa=ada/MA+wsa/MW;
Vwa=tmwa*359*29.92/Pa*(((dbTa-32)*5/9+273.15)*9/5)/492 "359 in cuft is standard volume; 29.92 standard pressure in in.Hg; 492 standard temp in degree R";
taH2=wsa/MW+ba*pWcf/100/MW+ba*pMcf/100/MW+ba*pHcf/100/MH2;
ppWsg=taH2/(taH2+asg)*Pa "This corresponds to a dew point of 36 degree C";
mwg=taH2+asg;
Vgp=mwg*359*29.92/Pa*(((Tfg-32)*5/9+273.15)*9/5)/492;
rCb=ba*pCcf/100-Csg-Cr;
rNb=Nc+Na-N2sg;
rHb=wsa/MW*MH2+ba*pWcf/100/MW*MH2+ba*pMcf/100/MW*MH2+ba*pHcf/100-taH2*MH2;
rAb=ba*pAcf/100-wr*pAap/100;
rOb=ba*pWcf/100*MO/MW+ba*pMcf/100*MO/MW+Na/MN2*0.21/0.79*2*MO+wsa/MW*MO-CO2sg/MCO2*MO*2-COsg/MCO*MO-O2sg-taH2*MO;
Orc=CC/MC+pHcf*ba/100/MH2/2;
Arc=Orc/0.21;
Ae=ada-Arc;
hvC=ba*thv;
Ewv=wsa/MW*hv;
thi=hvC+Ewv;
hvr=hvR*Cr;
hvSG=hvsg*c1*COsg/MCO;
Er=wr*sha*(Tap-dbTa);
Edsg=CO2sg/MCO2*hcCO2*(Tfg-dbTa)+COsg/MCO*hcCO*(Tfg-dbTa)+O2sg/(MO*2)*hcO2*(Tfg-dbTa)+N2sg/MN2*hcN2*(Tfg-dbTa);
Ewsg=hv*taH2+taH2*(Tfg-dbTa)*hcW;
Hgs=(wwe/tw*ba)*1018.6 "1018.6Btu/lb is the net heat input into steam ie Enthalpy of 1 lb steam as produced-Enthalpy of feed water";
tho=hvr+hvSG+Er+Edsg+Ewsg+Hgs;
ul=thi-tho;
end Ex11_4;
