package Ex2_3
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-2:Stoichometric and composition Relationships
  //Example 2.3; Page 31
  //Title: Finding the weight of iron and steam required to produce 100lb of Hydrogen and weight of Fe3O4 formed

  model Ex2_3_a
    //parameter section
    parameter Real wH(unit = "lb") = 100 "weight of hydrogen to be produced";
    parameter Real MH(unit = "g") = 2.016 "Molar weight of hydrogen molecule";
    parameter Real MFe(unit = "g") = 55.84 "Molar weight of iron";
    parameter Real MH2O(unit = "g") = 18.02 "molar weight of steam";
    parameter Real MFO(unit = "g") = 231.5 "molar weight of Fe3O4";
    //variable section
    Real nH(unit = "lb-moles") "number of moles of H2 formed";
    Real nFe(unit = "lb-moles") "number of moles of Fe used";
    Real nH2O(unit = "lb-moles") "number of moles of H2O used";
    Real nFO(unit = "lb-moles") "number of moles of Fe3O4 formed";
    Real wFe(unit = "lb") "weight of Fe required";
    Real wH2O(unit = "lb") "weight of H2O required";
    Real wFO(unit = "lb") "weight of Fe3O4 formed";
    //equation section
  equation
    nH = wH / MH;
    nFe = nH * 3 / 4;
    nH2O = nH * 4 / 4;
    nFO = nH / 4;
    wFe = nFe * MFe;
    wH2O = nH2O * MH2O;
    wFO = nFO * MFO;
  end Ex2_3_a;

    //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
    //Chapter-2:Stoichometric and composition Relationships
    //Example 2.3b; Page 31
    //Title: Finding the volume occupied by 100lb H2 at standard conditions
    model Ex2_3_b
    //parameter section
    parameter Real m(unit = "lb") = 100 "Given mass of H2";
    parameter Real M(unit = "g") = 2.016 "Molar mass of H2";
    parameter Real V(unit = "(cu ft)/lb-mole") = 359 "Specific volume of any gas at standard conditions";
    //variable section
    Real v(unit = "cu ft") "volume occupied by 100lb H2 at standard conditions";
    Real n(unit = "lb-moles") "number of moles of 100lb H2";
    //equation section
  equation
    n = m / M "Finding number of moles";
    v = n * V "Finding volume occupied by 100lb H2";
  end Ex2_3_b;

end Ex2_3;
